using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;



namespace CSConsoleSample
{
    class Program
     {
     
        private static int WimWorkCB(uint dwEvent, uint dwEventParam, uint dwWin32Err, int lpParam, int lpUserParam)
        {
            switch (dwEvent)
            {
                case Wimadll.DWEV_PROGRESSPERCENT:
                    Console.Write("\x08\x08\x08\x08\x08");
                    string str = dwEventParam.ToString();
                    if (str.Length < 2)
                        str = "0" + str;
                    if (str.Length < 3)
                        str = " " + str;
                    Console.Write(str);
                    Console.Write(" %");
                    break;
            };
            return 0;
        }



        static void doListDisk()
        {
            uint nbDisk = Wimadll.GetNumberPhysicalDisk();
            Console.WriteLine("nb disk = " + nbDisk);
            for (uint i=0;i<nbDisk;i++)
            {
                uint sizelow=0;
                uint sizehigh=0;
                bool isRemovable=false;
                StringBuilder sb = new StringBuilder(80 + 1);
                if (Wimadll.GetPhysicalDiskSizeAndInfo( i,ref sizelow,ref sizehigh, ref isRemovable, 
                     sb, 80))
                {
                    UInt64 sizeOfDisk = (((UInt64)(sizehigh)) << 32) | (((UInt64)(sizelow)));
                    uint sizeOfDiskMB = (uint)(sizeOfDisk / (1024 * 1024));
                    Console.WriteLine("disk " + i + " removable : " + isRemovable + " name :" + sb.ToString() + " size : " + sizeOfDiskMB + " MB");
                }
            }
        }
        static void Main(string[] args)
        {


            if (args.Length == 0)
            {
                Console.WriteLine("CsConsoleSample : C# sample of WinImage SDK");
                Console.WriteLine("");
                Console.WriteLine("usage:");
                Console.WriteLine("CsConsoleSample ListDisk");
                Console.WriteLine("CsConsoleSample MakeVhdDynamic <numdisk> <FileName>");
                Console.WriteLine("where:");
                Console.WriteLine("  big_image_file : full pathname of an uncompressed drive image. Can be");
                Console.WriteLine("     Virtual PC/Server VHD file or VMWare VMDK file");
                Console.WriteLine("  filename_to_extract (optional) : a filename you want extract (without wildcard)");
                Console.WriteLine("  location_to_extract (optional) : path where you want extract");

                doListDisk();
            }
            else
            if ((args.Length >= 1) && (args[0] == "ListDisk"))
            {
               doListDisk();

            }
            if ((args.Length >= 3) && (args[0] == "MakeVhdDynamic"))
            {
               uint numdisk = ((uint)int.Parse(args[1])) ;
               string filename = args[2];
               bool success = Wimadll.CreatePhysicalDiskImageCB((IntPtr)0, WimWorkCB, (IntPtr)0, numdisk, filename, Wimadll.PHYSICALDISKIMAGEFORMAT.PHYSICALDISKIMAGEFORMAT_VHDDYNAMIC);

               Console.WriteLine("success :" + success);
            }
            else
            {
                Console.WriteLine("invalid arg. rerun without parameters");
            }
        }
    }
}