// WinImage DLL c# header
// translation of winimage.h header, made with the help of Tom McCartney

using System.Runtime.InteropServices;
using System;
internal static class Wimadll
{
    #region EnumeratedTypes
    // value for CaRead or CaCompare or CaWrite or CaFormat
    public enum ChoiceApp { caNOTHING = 0, caUSED, caAll, caBEGINFLOPPY, caONLYBOOT };
    //public const short FL_NOTHING = 0;
    //public const short FL_USED = 1;
    //public const short FL_ALL = 2;
    //public const short FL_BEGINFLOPPY = 3;
    public enum LOCATEERROR { ON_FORMAT = 0, ON_READ = 1, ON_WRITE = 2, ON_COMPARE = 3 };
    //public const short ON_FORMAT = 0;
    //public const short ON_READ = 1;
    //public const short ON_WRITE = 2;
    //public const short ON_COMPARE = 3;
    public enum DriveInfo { NO_FLOPPY = 0, FLOPPY_360 = 1, FLOPPY_12M = 2, FLOPPY_720 = 3, FLOPPY_144 = 4, FLOPPY_288 = 5, LDISK_REMOVABLE = 6, LDISK_HARDDISK = 7, LDIST_CDROM = 8, FLOPPY_LS120 = 9 };
    //DriveInfo return:
    //      NO_FLOPPY=0,
    //      FLOPPY_360=1,
    //      FLOPPY_12M=2,
    //      FLOPPY_720=3,
    //      FLOPPY_144=4,
    //      FLOPPY_288=5,
    //      LDISK_REMOVABLE=6,
    //      LDISK_HARDDISK=7,
    //      LDISK_CDROM=8,
    //      FLOPPY_LS120=9

    public enum PHYSICALDISKIMAGEFORMAT { PHYSICALDISKIMAGEFORMAT_UNKNOWN = 0, PHYSICALDISKIMAGEFORMAT_FIXED, PHYSICALDISKIMAGEFORMAT_VHDFIXED,
        PHYSICALDISKIMAGEFORMAT_VHDDYNAMIC, PHYSICALDISKIMAGEFORMAT_VMDKFIXED, PHYSICALDISKIMAGEFORMAT_VMDKDYNAMIC };

    #endregion
    #region Constants
    public const short MAXLFN = 256;

    public const byte SORT_NONE = 72;
    public const byte SORT_NAME = 73;
    public const byte SORT_EXT = 74;
    public const byte SORT_SIZE = 75;
    public const byte SORT_DATE = 76;

    //Mode Values for ChDir function
    public const byte CDM_ROOT = 50;
    public const byte CDM_UPPER = 51;
    public const byte CDM_ENTRY = 52;

    //Values for Floppy Density for MakeFloppyImage
    public const short FLOPPY_160K = 0;
    public const short FLOPPY_180K = 1;
    public const short FLOPPY_320K = 2;
    public const short FLOPPY_360K = 3;
    public const short FLOPPY_720K = 4;
    public const short FLOPPY_1200K = 5;
    public const short FLOPPY_1440K = 6;
    public const short FLOPPY_2880K = 7;
    public const short FLOPPY_DMF2048K = 8;
    public const short FLOPPY_DMF1024K = 9;
    public const short FLOPPY_1680K = 10;

    private const string DEBENUSTD = "ENU";
    private const short BASEENUSTD = (10000);



    public const int DWEV_ERRORSUPINFO = 0X7FFF0001;
    //#define DWEV_ERRORSUPINFO       ((DWORD)0x7fff0001)
    //// IO Error with supplemental info (in ReadFloppy and WriteFloppy)
    //// dwEventParam = WinImage error number (see below), Bios like error number
    //// dwWin32Err : Win32 error number, like GetLastError()
    //// lpParam * pointer to an ERROR_SUPINFO structure
    //// return value : IDRETRY (4), IDABORT (3), IDIGNORE (5) or  IDCANCEL (2)
    ////   dwEventParam = 0x01         "Internal error 1\n"
    ////   dwEventParam = 0x02         "Address mark not found"
    ////   dwEventParam = 0x03         "Diskette is write-protected"
    ////   dwEventParam = 0x04         "Sector not found"
    ////   dwEventParam = 0x08         "DMA overflow"
    ////   dwEventParam = 0x09         "Internal error 9"
    ////   dwEventParam = 0x10         "Error in reading"
    ////   dwEventParam = 0x20         "Error in floppy adapter"
    ////   dwEventParam = 0x40         "Track not found"
    ////   dwEventParam = 0x80         "There is no floppy in the drive"
    ////   dwEventParam = 0x100        "Floppies do not match"
    //
    //
    public const int DWEV_ERRORWIN32 = 0X7FFF0002;
    //#define DWEV_ERRORWIN32         ((DWORD)0x7fff0002)
    //// Win32 IO Error in ReadFloppy and WriteFloppy and ReadLargeIma and WriteLargeIma
    //// dwEventParam = WinImage error number (see DWEV_ERRORSUPINFO), Bios like error number or 0
    //// dwWin32Err : Win32 error number, like GetLastError()
    //// return value : IDRETRY to retry (when possible)
    //// elsewhere (IDCANCEL or 0) to stop
    //
    //
    public const int DWEV_ERRORCANTACCESS = 0X7FFF0003;
    //#define DWEV_ERRORCANTACCESS    ((DWORD)0x7fff0003)
    //// in ReadFloppy* and WriteFloppy*
    //// "Drive cannot be accessed - Check to see if another application is using it"
    //// return value not used
    //
    public const int DWEV_ERRORDRIVEEMPTY = 0X7FFF0004;
    //#define DWEV_ERRORDRIVEEMPTY    ((DWORD)0x7fff0004)
    //// in ReadFloppy* and WriteFloppy*
    //// "There is no floppy in the drive"
    //// return value not used
    //
    public const int DWEV_ERROR_NOT_MATCH = 0X7FFF0005;
    //#define DWEV_ERROR_NOT_MATCH    ((DWORD)0x7fff0005)
    //// in ReadFloppy*
    //// "Floppies do not match"
    //// return value not used
    //
    public const int DWEV_UNSTDFMT = 0X7FFF0006;
    //#define DWEV_UNSTDFMT           ((DWORD)0x7fff0006)
    //// in ReadFloppy* and WriteFloppy*
    //// "The current image format differs from the standard format for this disk drive"
    //// return value : IDOK (1) to continue, IDCANCEL to abort
    //
    public const int DWEV_UNSUPFMT = 0X7FFF0007;
    //#define DWEV_UNSUPFMT           ((DWORD)0x7fff0007)
    //// in WriteFloppy* and WriteLargeIma
    //// "The current image format is not supported by the disk drive"
    //// return value not used
    //
    public const int DWEV_DIFFTYPEDISK = 0X7FFF0008;
    //#define DWEV_DIFFTYPEDISK       ((DWORD)0x7fff0008)
    //// in WriteFloppy*
    //// "Disk and image formats do not match\nDo you want to reformat it?"
    //// return IDYES (6) or IDNO (7)
    //
    public const int DWEV_DISKHASDATA = 0X7FFF0009;
    //#define DWEV_DISKHASDATA        ((DWORD)0x7fff0009)
    //// in WriteFloppy*
    //// "Disk is not empty, all data on your disk will be lost!\nDo you want to continue?"
    //// return IDYES (6) or IDNO (7)
    //
    public const int DWEV_PROGRESSPERCENT = 0X7FFF000A;
    //#define DWEV_PROGRESSPERCENT    ((DWORD)0x7fff000a)
    //// Give % progress info
    //// dwEventParam between 0 and 100
    //// for ExtractFile and InjectFile, lpParam contain a PROGRESSFILE_SUPINFO structure
    //// return value : IDCANCEL (2) to stop, 0 to continue
    //
    public const int DWEV_ERRORASPI = 0X7FFF000B;
    //#define DWEV_ERRORASPI          ((DWORD)0x7fff000b)
    //// Aspi error in WimLargeReadAspiCDImage*
    //// dwEventParam contain first sector number of range error
    //// return value : IDABORT, IDRETRY or IDIGNORE
    //
    public const int DWEV_ERRORWRITEIMAGEFILE = 0X7FFF000C;
    //#define DWEV_ERRORWRITEIMAGEFILE    ((DWORD)0x7fff000c)
    //// error in writing image file in WimLargeReadAspiCDImage*
    //// dwWin32Err : Win32 error number, like GetLastError()
    //
    //
    public const int DWEV_ERRORIOCTL = 0X7FFF000D;
    //#define DWEV_ERRORIOCTL             ((DWORD)0x7fff000d)
    //// IOCTL error when reading Disk partition under Win9x
    //// dwEventParam is Int25/26 error value
    //// return value : IDCANCEL or IDRETRY
    //
    public const int DWEV_ROOTREADDONE = 0X7FFF000E;
    //// when reading FAT image, say when the root is read
    //// return value is not used

    public const uint ERRINFO_MOVEFILE_DESTINATIONEQUALSOURCE = 0X80000001;
    public const uint ERRINFO_MOVEFILE_DESTINATIONSUBFOLERDEPL = 0X80000002;

    #endregion
    #region Structures

    [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi, Pack=1)]
    public struct DIRINFO
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public char[] nom; //Supposed to be 8 bytes
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public char[] ext; //Supposed to be 3 bytes
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 13)]
        public char[] szCompactName; //Supposed to be 13 bytes
        public byte bAttr;
        public byte dir_CreateMSec;
        public short dir_CreateDate;
        public short DosTime;
        public short DosDate;
        public bool fIsSubDir;
        public bool fSel; //Boolean
        public bool fLfnEntry;
        public int dwSize;
        public uint uiPosInDir;
        public int dwLocalisation;
        public int dwTrueSize;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAXLFN)]
        public char[] longname; //Supposed to be MAXLFN bytes (MAXLFN Const defined above)
        public short dir_CreateTime;
        public short dir_LastAccessDate;
    }

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct ASPIINQUIRYTAB
    {
        public int dwSizeStruct;
        public int dwHost;
        public int dwTargetID;
        public int dwTargetType;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public char[] szDeviceName; //Supposed to be 32 bytes
    }

    // // for ExtractFile and InjectFile, in event DWEV_PROGRESSPERCENT lpParam contain a
    // //    PROGRESSFILE_SUPINFO structure

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct PROGRESSFILE_SUPINFO
    {
        public int dwSizeStruct;
        public int dwCurrentPos;
        public int dwReserved1;
        public int dwTotalSize;
        public int dwReserved2;
        public string lpszName;
        public string lpszFullName;
    }


    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct PARTITION
    {
        public byte bActivate ;
        public byte bHeadBegin ;
        public short wCylSectBegin ;

        public byte bType ;
        public byte bHeadEnd ;
        public short wCylSectEnd ;

        public int dwDist ;
        public int dwSize ;
    }


    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct PARTDESC
    {
        public PARTITION partition;
        public int dwPos ;
        public int dwPosPartition ;
        public int fIsFat32 ;
        public int fIsFat ;
        public int fIsNtfs ;
        public int fIsLinux ;
        public byte bDisk ;
        public byte bFill0 ;
        public byte bFill1 ;
        public byte bFill2 ;
    }


    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct PARTITION_CREATION_INFO
    {
        public uint dwPartitionType;
        public uint dwPartitionSize;
        public uint dwPositLba;
        public uint dwCreationFat; // 0, 16 or 32
        public uint dwClusterSize;
        public uint dwRootEntryFat1216;
        public uint dwDummy1;
        public uint dwDummy2;
    }

    public const int MAXPARTITION = (32);
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct PARTDESCArray
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = MAXPARTITION)]
                public PARTDESC[] partItem;
    }



    //// dwEvent contain a DWEV_xxx value, see below
    //// lpUsrParam contain user param gived to function
    //

    //typedef struct
    //{
    //    DWORD dwSizeStruct;
    //    LOCATEERROR LocErr;
    //    DWORD dwHead;
    //    DWORD dwTrack;

    //    DWORD dwPosLow;
    //    DWORD dwPosHigh;
    //    DWORD dwStyleAnswer;

    //    DWORD dwErrNumber;
    //    LPCTSTR lpszErrorText;
    //} ERROR_SUPINFO;

    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi, Pack = 1)]
    public struct ERROR_SUPINFO
    {
        public int dwSizeStruct;
        public LOCATEERROR LocErr;
        public int dwHead;
        public int dwTrack;
        public int dwPosLow;
        public int dwPosHigh;
        public int dwStyleAnswer;
        public int dwErrNumber;
        public string lpszErrorTest;
    }
    #endregion
    #region CallBacks
    //''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    // Callback stuff

    public delegate int WimCB(uint dwEvent, uint dwEventParam, uint dwWin32Err, int lpParam, int lpUserParam);
    //I believe that the lpParam and lpUserParams are pointers to structures with information
    //''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    #endregion

    #region DLL Function Declarations
    // CreateMemFatHima : Create an Image Object.
    // you need call ReadImaFile, ReadFloppy or MakeEmptyImage
    [DllImport("wimadll.dll", EntryPoint = "CreateMemFatHima", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr CreateMemFatHima();
    // CreateMemHfsHima : Create an Image Object for Mac floppy.
    // you need call ReadImaFile, ReadFloppy
    // extract, inject... cannot be used
    [DllImport("wimadll.dll", EntryPoint = "CreateMemHfsHima", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr CreateMemHfsHima();

    // CreateCDIsoIma : Create an Image Object by loading CDRom ISO image
    //  lpFn : Filename of .ISO file
    //  inject,...cannot be used
    [DllImport("wimadll.dll", EntryPoint = "CreateCDIsoIma", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr CreateCDIsoIma(string lpFn);

    // OpenFatLargeFile : Open a large disk image (hard disk image)
    //  hWnd : parent window for progress window
    //  lpFn : FileName
    //  dwPosFileBegin : position in file (usualy 0)
    //  dwPosFileBegin : position in file, high (usualy 0), for file > 4GB
    //  fReadOnlyAsked : if the file must be opened in read-only mode
    //HIMA WIMAAPI OpenFatLargeFile(HWND hWnd,LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);
    //HIMA WIMAAPI OpenFatLargeFileCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                                LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);
    [DllImport("wimadll.dll", EntryPoint = "OpenFatLargeFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr OpenFatLargeFile(IntPtr hWnd, string lpFn, int dwPosInFile, int dwPosInFileHigh, bool fReadOnlyAsked);
    [DllImport("wimadll.dll", EntryPoint = "OpenFatLargeFileCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr OpenFatLargeFileCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpFn, int dwPosInFile, int dwPosInFileHigh, bool fReadOnlyAsked);
    [DllImport("wimadll.dll", EntryPoint = "OpenLargeImageFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern IntPtr OpenLargeImageFile(IntPtr hWnd, string lpFn, int dwPosInFile, int dwPosInFileHigh, bool fReadOnlyAsked);

    // DeleteIma : Delete an Image Object.
    [DllImport("wimadll.dll", EntryPoint = "DeleteIma", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern void DeleteIma(IntPtr Ima);


    // ReadImaFile: Read an image file (.IMA or .IMZ)
    //  hWnd : parent window for progress window
    //  lpFn : FileName
    //  lpfCompr : pointer to Boolean (will receive TRUE if file is compressed)
    //  dwPosFileBegin : position in file (usualy 0, except in WLZ)
    [DllImport("wimadll.dll", EntryPoint = "ReadImaFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadImaFile(IntPtr Ima, IntPtr hWnd, string lpFn, ref bool lpfCompr, int dwPosFileBegin);
    [DllImport("wimadll.dll", EntryPoint = "ReadImaFileEx", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadImaFileEx(IntPtr Ima, IntPtr hWnd, string lpFn, ref bool lpfCompr, int dwPosFileBegin, string lpszPassword);
    [DllImport("wimadll.dll", EntryPoint = "ReadImaFileExCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadImaFileExCB(IntPtr Ima, IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpFn, ref bool lpfCompr, int dwPosFileBegin, string lpszPassword);

    // WriteImaFile : WriteCompressed image
    //  hWnd : parent window for progress window
    //  lpFn : FileName
    //  fTruncate : TRUE if you want truncate unused part of image
    //  fCompress : TRUE if you want compress
    //  iLevelCompress : used is fCompress is TRUE, level of compress (1 to 9)
    //  dwPosBeginWrite : position in file (usualy 0)
    //  lpNameInCompr : alternate name in compressed file (can be NULL)
    [DllImport("wimadll.dll", EntryPoint = "WriteImaFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteImaFile(IntPtr Ima, IntPtr hWnd, string lpFn, bool fTruncate, bool fCompr, int iLevelCompress, int dwPosBeginWrite, string lpNameInCompr);
    [DllImport("wimadll.dll", EntryPoint = "WriteImaFileEx", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteImaFileEx(IntPtr Ima, IntPtr hWnd, string lpFn, bool fTruncate, bool fCompr, int iLevelCompress, int dwPosBeginWrite, string lpNameInCompr, string lpszPassword);
    [DllImport("wimadll.dll", EntryPoint = "WriteImaFileExCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteImaFileExCB(IntPtr Ima, IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpFn, bool fTruncate, bool fCompr, int iLevelCompress, int dwPosBeginWrite, string lpNameInCompr, string lpszPassword);



    //  ReadFloppy : Read a floppy
    //  hWnd : parent window for progress window
    //  bFloppy : Floppy to read (0 for A:)
    //  caRead : USED, or ALL (ALL if you want read unused part of floppy)
    // BOOL WIMAAPI ReadFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caRead);
    [DllImport("wimadll.dll", EntryPoint = "ReadFloppy", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadFloppy(IntPtr Ima, IntPtr hWnd, byte bFloppy, ChoiceApp caRead);
    [DllImport("wimadll.dll", EntryPoint = "ReadFloppyCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadFloppyCB(IntPtr Ima, IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, byte bFloppy, ChoiceApp caRead);

    // WriteFloppy : Write a floppy
    //  hWnd : parent window for progress window
    //  bFloppy : Floppy to write (0 for A:)
    //  caFormat : NOTHING or ALL (ALL for format)
    //  caWrite : USED or ALL
    //  caCompare : NOTHING, USED or ALL
    //  fCheckDiskBeforeWrite : if you want check disk is empty
    //BOOL WIMAAPI WriteFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caFormat,
    //                        CHOICEAPP caWrite,CHOICEAPP caCompare,
    //                        BYTE fCheckDiskBeforeWrite);alias
    [DllImport("wimadll.dll", EntryPoint = "WriteFloppy", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteFloppy(IntPtr Ima, IntPtr hWnd, byte bFloppy, ChoiceApp caFormat, ChoiceApp caWrite, ChoiceApp caCompare, byte fCheckDiskBeforeWrite);
    [DllImport("wimadll.dll", EntryPoint = "WriteFloppyCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteFloppyCB(IntPtr Ima, IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, byte bFloppy, ChoiceApp caFormat, ChoiceApp caWrite, ChoiceApp caCompare, byte fCheckDiskBeforeWrite);


    // Create a directory in the image
    //  lpDir : Directory name
    // BOOL WIMAAPI MkDir(HIMA hIma,LPSTR lpDir);
    //UPGRADE_NOTE: MkDir was upgraded to MkDir_Renamed. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1061"'
    [DllImport("wimadll.dll", EntryPoint = "MkDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool MkDir(IntPtr Ima, string lpDir);

    // Change current directory by name
    //  lpDir : Directory name
    // BOOL WIMAAPI ChszDir(HIMA hIma,LPSTR lpDir);
    [DllImport("wimadll.dll", EntryPoint = "ChszDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ChszDir(IntPtr Ima, string lpDir);

    // Change current directory by mode
    //  bMode : CDM_ROOT or CDM_UPPER (equiv. to cd \ and cd ..)
    // BOOL WIMAAPI ChDir(HIMA hIma,BYTE bMode);

    [DllImport("wimadll.dll", EntryPoint = "ChDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ChDir(IntPtr Ima, byte bMode);

    [DllImport("wimadll.dll", EntryPoint = "ChDirPos", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ChDirPos(IntPtr Ima, byte bMode, int dwPosDir);

    // InjectFile : Inject a file in floppy
    //  lpFn : file to inject
    //  lpDwSize : Pointer to DWORD that will receive the size. Can be NULL.
    //  lpTooBig : Pointer to BOOL, become TRUE if file too big to be injected
    //      (if InjectFile return FALSE). Can be NULL.
    //  lpNameWhenInjected : if not NULL, contain a new name in the image
    //      (if the file must have another name when injected). Can be NULL.
    //    for the CB version, the only event is DWEV_PROGRESSPERCENT
    //BOOL WIMAAPI InjectFile(HIMA hIma,LPSTR lpFn,
    //                        LPDWORD lpDwSize,LPBOOL lpTooBig,
    //                        LPSTR lpNameWhenInjected);
    [DllImport("wimadll.dll", EntryPoint = "InjectFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool InjectFile(IntPtr Ima, string lpFn, ref int lpdwSize, ref bool lpTooBig, string lpNameWhenInjected);
    [DllImport("wimadll.dll", EntryPoint = "InjectFileCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool InjectFileCB(IntPtr Ima, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpFn, ref int lpdwSize, ref bool lpTooBig, string lpNameWhenInjected);


    // MakeEmptyImage : make an empty image
    // iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K
    //                  0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-))
    //BOOL WIMAAPI MakeEmptyImage(HIMA hIma,int iNoTypeDisk);
    [DllImport("wimadll.dll", EntryPoint = "MakeEmptyImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool MakeEmptyImage(IntPtr Ima, int iNoTypeDisk);
    [DllImport("wimadll.dll", EntryPoint = "MakeEmptyImageEx", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool MakeEmptyImageEx(IntPtr Ima, string lpszBootSectorGeom, string lpszBootSectorCode);



    [DllImport("wimadll.dll", EntryPoint = "BuildImaNewFormat", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern int BuildImaNewFormat(IntPtr hOldIma, bool fNewTypeDisk, int iNoTypeDisk);
    [DllImport("wimadll.dll", EntryPoint = "BuildImaNewFormatEx", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool BuildImaNewFormatEx(IntPtr hOldIma, IntPtr hNewIma, string lpszBootSectForGeometry, bool fDiscardOldIma);
    [DllImport("wimadll.dll", EntryPoint = "BuildImaNewFormatExCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool BuildImaNewFormatExCB(IntPtr hOldIma, IntPtr hNewIma, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpszBootSectForGeometry, bool fDiscardOldIma);

    // InitWimaSdk : Init the DLL and use hinstdll for resource
    // BOOL WIMAAPI InitWimaSdk(HINSTANCE hinstdll,LPSTR lpDeb,WORD wBase);
    [DllImport("wimadll.dll", EntryPoint = "InitWimaSdk", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool InitWimaSdk(IntPtr hinstdll, string lpDeb, short wBase);

    // GetCurDir : Get the name of current directory
    //  lpBuf : buffer that will receive the name
    //  uiMaxSize : the size of buffer
    // BOOL WIMAAPI GetCurDir(HIMA hIma,LPSTR lpBuf,UINT uiMaxSize);
    [DllImport("wimadll.dll", EntryPoint = "GetCurDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetCurDir(IntPtr Ima, [MarshalAs(UnmanagedType.LPStr)] System.Text.StringBuilder lpBuf, uint uiMaxSize);

    // GetNbEntryCurDir : Get the number of entry of cur directory
    // DWORD WIMAAPI GetNbEntryCurDir(HIMA hIma);
    [DllImport("wimadll.dll", EntryPoint = "GetNbEntryCurDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern int GetNbEntryCurDir(IntPtr Ima);

    // GetDirInfo : Get info about the entry of cur directory
    //  LPDIRINFO : array of DIRINFO that will receive the info
    //                  (use GetNbEntryCurDir for know the size needed)
    //  bSort :     specify how the file must be sort
    //          (SORT_NONE, SORT_NAME, SORT_EXT, SORT_SIZE or SORT_DATE)
    // BOOL WIMAAPI GetDirInfo(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);
    //' GetDirInfo and Sort MUST BE CHECKED IN BASIC!!!
    //UPGRADE_WARNING: Structure DIRINFO may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    [DllImport("wimadll.dll", EntryPoint = "GetDirInfo", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetDirInfo(IntPtr Ima, [In, Out] [MarshalAs(UnmanagedType.LPArray)] DIRINFO[] di, byte bSort);



    //' use these three function to get one item by function call
    //Declare Function RefreshInternalBufferDirInfo Lib "wimadll.dll" (ByVal Ima As IntPtr, ByVal bSort As Byte, ByRef dwNumberItem As Integer) As Boolean
    [DllImport("wimadll.dll", EntryPoint = "RefreshInternalBufferDirInfo", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RefreshInternalBufferDirInfo(IntPtr Ima, byte bSort, ref int pdwNumberItem);

    //Declare Function GetBufferDirInfoItem Lib "wimadll.dll" (ByVal Ima As IntPtr, ByRef diItem As DIRINFO, ByVal dwItemPos As Integer) As Boolean
    [DllImport("wimadll.dll", EntryPoint = "GetBufferDirInfoItem", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetBufferDirInfoItem(IntPtr Ima, ref DIRINFO diItem, int dwItemPos);

    //Declare Function ReSortBufferDirInfo Lib "wimadll.dll" (ByVal Ima As IntPtr, ByVal bSort As Byte) As Boolean
    [DllImport("wimadll.dll", EntryPoint = "ReSortBufferDirInfo", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReSortBufferDirInfo(IntPtr Ima, byte bSort);

    // Sort : Resort the array obtained by GetDirInfo
    //BOOL WIMAAPI Sort(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);
    //UPGRADE_WARNING: Structure DIRINFO may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    [DllImport("wimadll.dll", EntryPoint = "Sort", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool Sort(IntPtr Ima, [In, Out] [MarshalAs(UnmanagedType.LPArray)] DIRINFO[] di, byte bSort);

    // GetLabel : Get the label of Image
    //  lpBuf : will receive the label
    //BOOL WIMAAPI GetLabel(HIMA hIma,LPSTR lpBuf);
    [DllImport("wimadll.dll", EntryPoint = "GetLabel", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    //public static extern bool GetLabel(int Ima, string label);
    public static extern bool GetLabel(IntPtr Ima, [MarshalAs(UnmanagedType.LPStr)] System.Text.StringBuilder lpDir);

    // SetLabel : Set the label of Image
    //  lpBuf : contain the new label
    // BOOL WIMAAPI SetLabel(HIMA hIma,LPSTR lpBuf);
    [DllImport("wimadll.dll", EntryPoint = "SetLabel", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool SetLabel(IntPtr Ima, string lpDir);

    // ExtractFile : Extract one file
    //  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
    //                  the file
    //  lpPath :    Path where extract the file
    //  lpFullName: will receive the exact full name of created file. Can be NULL
    //BOOL WIMAAPI ExtractFile(HIMA hIma,UINT uiPosDir,LPSTR lpPath,LPSTR lpFullName);
    // for the CB version, the only event is DWEV_PROGRESSPERCENT
    [DllImport("wimadll.dll", EntryPoint = "ExtractFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ExtractFile(IntPtr Ima, uint uiPosDir, string lpPath, [MarshalAs(UnmanagedType.LPStr)] System.Text.StringBuilder lpFullName);
    [DllImport("wimadll.dll", EntryPoint = "ExtractFileCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ExtractFileCB(IntPtr Ima, WimCB pEventNotifCallBack, IntPtr lpUsrParam, uint uiPosDir, string lpPath, [MarshalAs(UnmanagedType.LPStr)] System.Text.StringBuilder lpFullName);


    // CheckSpaceForFile : Check you've space for inject a file of dwSize bytes
    // BOOL WIMAAPI CheckSpaceForFile(HIMA hIma,DWORD dwSize);
    [DllImport("wimadll.dll", EntryPoint = "CheckSpaceForFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool CheckSpaceForFile(IntPtr Ima, int dwSize);

    // to know if an inject is possible but need replace
    //  lpFn : contain the name of file to be injected
    //  lpDwSize : will receive the size of old file with same name. Can be NULL
    //  lpNameWhenInjected : if not NULL, contain a new name in the image
    //  lpShortName : will receive the short (8) name of file in image. Can be NULL
    //  lpShortExt  : will receive the short (3) ext of file in image. Can be NULL
    //      (if the file must have another name when injected)
    //BOOL WIMAAPI IfInjectPossibleButNeedReplace(HIMA hIma,LPSTR lpFn,
    //         LPDWORD lpDwSize,LPSTR lpShortName,
    //         LPSTR lpShortExt,LPSTR lpNameWhenInjected);
    [DllImport("wimadll.dll", EntryPoint = "IfInjectPossibleButNeedReplace", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool IfInjectPossibleButNeedReplace(IntPtr Ima, string lpFn, ref int lpdwSize, string lpShortName, string lpShortExt, string lpNameWhenInjected);

    // RemoveDir : Remove a directory
    //  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
    //                  the file
    //BOOL WIMAAPI RmDir(HIMA hIma,UINT uiPosDir);
    //UPGRADE_NOTE: RmDir was upgraded to RmDir_Renamed. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1061"'
    [DllImport("wimadll.dll", EntryPoint = "RmDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RemoveDir(IntPtr Ima, int uiPosDir);

    // DeleteFileNameExt
    // Delete a file in the image
    // BOOL WIMAAPI DeleteFileNameExt(HIMA hIma,LPSTR lpNom,LPSTR lpExt,BOOL fRealDel);
    //     for filling lpNom and lpExt, use data obtained from GetDirInfo
    //   lpNom : pointer to array of 8 chars (name of 8.3 name, use DIRINFO.nom)
    //   lpExt : pointer to array of 3 chars (ext  of 8.3 name, use DIRINFO.ext)
    //   fRealDel : TRUE to really delete, FALSE to only test if delete is possible
    [DllImport("wimadll.dll", EntryPoint = "DeleteFileNameExt", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool DeleteFileNameExt(IntPtr Ima, string lpNom, string lpExt, bool fRealDel);

    //BOOL WIMAAPI MoveFileToDir(HIMA hIma,LPCSTR lpName,LPCSTR lpExt,LPCSTR lpszDestDir,
    //                           LPBOOL lpfReplaceNeeded,BOOL fDoRealMove,BOOL fDoReplaceIfNeeded,
    //                           LPDWORD lpdwErrInfo);
    [DllImport("wimadll.dll", EntryPoint = "MoveFileToDir", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool MoveFileToDir(IntPtr Ima, string lpName, string lpExt, string lpszDestDir, bool lpfReplaceNeeded, bool fDoRealMove, bool fDoReplaceIfNeeded, int lpdwErrInfo);

    // RenameFile :    Rename one file
    //  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
    //                  the file
    //  lpNewLongName: The new name of the file
    // BOOL RenameFile(HIMA hIma,UINT uiPosDir,LPCSTR lpNewLongName);
    [DllImport("wimadll.dll", EntryPoint = "RenameFile", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RenameFile(IntPtr Ima, int uiPosDir, string lpNewLongName);

    // ChangeDateAndAttribute :    Change the date and attribute of a File
    //  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
    //                  the file
    //  *lpbNewAttr:   Contain the new attribute of the file (or NULL to no change)
    //  *lpNewDosDate,
    //  *lpNewDosTime: Contain the Modified Date and Time (or NULL to no change)
    //  *lpbNewdir_CreateMSec,*lpwNewdir_CreateTime,*lpwNewdir_CreateDate
    //                 Contain the Created Date and Time (or NULL to no change)
    //  *lpwNewdir_LastAccessDate : Contain the Last Access Date (or NULL...)
    // BOOL ChangeDateAndAttribute(HIMA hIma,UINT uiPosDir,LPBYTE lpbNewAttr,
    //                                     LPWORD lpNewDosDate,LPWORD lpNewDosTime,
    //                                     LPBYTE lpbNewdir_CreateMSec,
    //                                     LPWORD lpwNewdir_CreateTime,LPWORD lpwNewdir_CreateDate,
    //                                     LPWORD lpwNewdir_LastAccessDate);
    [DllImport("wimadll.dll", EntryPoint = "ChangeDateAndAttribute", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern object ChangeDateAndAttribute(IntPtr Ima, int uiPosDir, ref byte NewAttr, ref short NewDosDate, ref short NewDosTime, ref byte Newdir_CreateMSec, ref short lpwNewdir_CreateTime, ref short Newdir_CreateDate, ref short lpwNewdir_LastAccessDate);

    // ReadData : Direct read data in image.
    //  dwPos :  begin position
    //  dwSize : number of byte to copy (size of buffer)
    //  lpBuf :  buffer that will receive data
    //BOOL WIMAAPI ReadData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);
    [DllImport("wimadll.dll", EntryPoint = "ReadData", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ReadData(IntPtr Ima, int dwPos, int dwSize, string lpBuf);

    // WriteData : Direct write data in image. Be carreful, WI don't refresh dir!
    //  dwPos :  begin position
    //  dwSize : number of byte to copy (size of buffer)
    //  lpBuf :  buffer that contain data
    //BOOL WIMAAPI WriteData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);
    [DllImport("wimadll.dll", EntryPoint = "WriteData", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteData(IntPtr Ima, int dwPos, int dwSize, string lpBuf);

    //// GetFatImaSizeFileName : Get information about UNCOMPRESSED Fat image
    ////   lpfn :          FileName
    ////   lpdwSize :      Will receive the size of the image, 32 bits low part of 64 bit data
    ////   lpdwSize!high : Will receive the size of the image, 32 bits high part of 64 bit data
    ////   lpfIsBigFat :   Boolean pointer, will receive TRUE if this is a large image (>2.88MB), not floppy image
    ////   lpdwPosInFile : Will receive the position of the image
    //BOOL WIMAAPI GetFatImaSizeFileName(LPCSTR lpFn,LPDWORD lpdwSize,LPDWORD lpdwSizeHigh,LPBOOL lpfIsBigFat,LPDWORD lpdwPosInFile);
    [DllImport("wimadll.dll", EntryPoint = "GetFatImaSizeFileName", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetFatImaSizeFileName(string lpFn, ref int lpdwSize, ref int lpdwSizeHigh, ref bool lpfIsBigFat, ref int lpdwPosInFile);


    //// GetDriveInfo : Get info about drive type
    ////  bDrive : number of driver (0 = 'A:', 1 = 'B:')
    ////  return the kind of drive
    //DRIVEINFO WIMAAPI GetDriveInfo(BYTE bDrive);
    [DllImport("wimadll.dll", EntryPoint = "GetDriveInfo", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern DriveInfo GetDriveInfo(byte bDrive);


    //// Fill the ASPI Inquiry array.
    //// if lpAspiCdRomInquityTab is NULL AND dwMaxNumberInArray==0, just return the number of ASPI CDrom Unit.
    ////  lpAspiCdRomInquityTab : Will receive the Array of SCSI Unit
    ////  dwMaxNumberInArray : size of array (in number of ASPIINQUIRYTAB)
    //DWORD WIMAAPI WimLargeAspiCdromInquiryFillArray(ASPIINQUIRYTAB* lpAspiCdRomInquityTab,DWORD dwMaxNumberInArray);
    //UPGRADE_WARNING: Structure ASPIINQUIRYTAB may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    [DllImport("wimadll.dll", EntryPoint = "WimLargeAspiCdromInquiryFillArray", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern int WimLargeAspiCdromInquiryFillArray([In, Out] [MarshalAs(UnmanagedType.LPArray)] ASPIINQUIRYTAB[] AspiInqTab, int dwMaxNumberInArray);

    //// Create a CDRom Image fro ASPI Unit, using dwHost and dwTargetID from AspiCdromInquiy
    ////   lpFn : Filename to create
    ////   lpdwTotal : will receive the filesize
    //// Note : I suggest using WimLargeReadAspiCDImageIgnoreError with fIgnoreError at FALSE
    //BOOL WIMAAPI WimLargeReadAspiCDImage(HWND hWnd,DWORD dwHost,DWORD dwTargetID,LPSTR lpFn,LPDWORD lpdwTotal);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeReadAspiCDImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeReadAspiCDImage(IntPtr hWnd, int dwHost, int dwTarget, string lpFn, ref int lpdwTotal);


    //// Like WimLargeReadAspiCDImage
    //// fIgnoreError :
    ////    FALSE : if there is error ignore it only if the error is after ISO9660 size (suggested)
    ////    TRUE : Ignore all ISO 9660 error
    //BOOL WIMAAPI WimLargeReadAspiCDImageIgnoreError(HWND hWnd,DWORD dwHost,DWORD dwTargetID,LPSTR lpFn,LPDWORD lpdwTotal,BOOL fIgnoreError);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeReadAspiCDImageIgnoreError", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeReadAspiCDImageIgnoreError(IntPtr hWnd, int dwHost, int dwTarget, string lpFn, ref int lpdwTotal, bool fIgnoreError);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeReadAspiCDImageIgnoreErrorCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeReadAspiCDImageIgnoreErrorCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, int dwHost, int dwTarget, string lpFn, ref int lpdwTotal, bool fIgnoreError);

    //// return value != 0 if WimLargeReadLargeIma can be used with CDRom
    //// (elsewhere, only hard disk partition)
    //DWORD WIMAAPI WimLargeIsReadImaIsoPossible();
    [DllImport("wimadll.dll", EntryPoint = "WimLargeIsReadImaIsoPossible", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern int WimLargeIsReadImaIsoPossible();

    //// Read Disk partition to image
    ////  cDrive : disk letter ('C' for disk C:...)
    ////  lpdwTotal : will receive number of byte processed
    ////  caRead : USED, or ALL (ALL if you want read unused part of disk)
    //BOOL WIMAAPI WimLargeReadLargeIma(HWND hWnd,char cDrive,LPSTR lpFn,LPDWORD lpdwTotal,CHOICEAPP caRead);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeReadLargeIma", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeReadLargeIma(IntPtr hWnd, byte cDrive, string lpFn, ref int lpdwTotal, ChoiceApp caRead);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeReadLargeImaCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeReadLargeImaCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, byte cDrive, string lpFn, ref int lpdwTotal, ChoiceApp caRead);

    //// Write Disk partition from image
    ////  cDrive : disk letter ('C' for disk C:...)
    ////  lpdwTotal : will receive number of byte processed
    ////  caWrite : USED or ALL
    ////  fCheckDiskBeforeWrite : if you want check disk is empty
    //BOOL WIMAAPI WimLargeWriteLargeIma(HIMA hIma,HWND hWnd,char cDrive,LPDWORD lpdwTotal CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeWriteLargeIma", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeWriteLargeIma(IntPtr Ima, IntPtr hWnd, byte cDrive, ref int lpdwTotal, ChoiceApp caWrite, bool fCheckDiskBeforeWriteThis);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeWriteLargeImaCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeWriteLargeImaCB(IntPtr Ima, IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, byte cDrive, ref int lpdwTotal, ChoiceApp caWrite, bool fCheckDiskBeforeWriteThis);


    //// say if a letter if a CDRom
    //BOOL WIMAAPI WimLargeIsIsoCDDrive(char cDrive);
    [DllImport("wimadll.dll", EntryPoint = "WimLargeIsIsoCDDrive", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WimLargeIsIsoCDDrive(char cDrive);

    //// Write the boot sector of an image
    //BOOL WIMAAPI WriteSectBoot(HIMA hIma,const BYTE* lpBuf,DWORD dwSizeBuf);
    [DllImport("wimadll.dll", EntryPoint = "WriteSectBoot", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool WriteSectBoot(IntPtr Ima, string lpBuf, int dwSizeBuf);

    //// Read the boot sector of an image
    //BOOL WIMAAPI GetSectBoot(HIMA hIma,LPBYTE lpBuf,DWORD dwSizeBuf,LPDWORD lpdwSizeBoot);
    [DllImport("wimadll.dll", EntryPoint = "GetSectBoot", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetSectBoot(IntPtr Ima, string lpBuf, int dwSizeBuf, ref int lpdwSizeBoot);

    // // Get the total size of an image
    // BOOL WIMAAPI GetImageSize(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh)
    [DllImport("wimadll.dll", EntryPoint = "GetImageSize", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetImageSize(IntPtr Ima, ref int lpdwLow, ref int lpdwHigh);

    // // Get the free space in an image
    // BOOL WIMAAPI GetFreeSpaceInImage(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh)
    [DllImport("wimadll.dll", EntryPoint = "GetFreeSpaceInImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetFreeSpaceInImage(IntPtr Ima, ref int lpdwLow, ref int lpdwHigh);


    //Declare Function MakePartitionList Lib "wimadll.dll" (ByVal lpFn As String, ByVal lpszPassword As String, ByRef dwNbPartFound As Integer, ByRef dwNbFat32Found As Integer, ByVal dwArraySize As Integer, ByRef PartList As PARTDESCArray) As Integer
    [DllImport("wimadll.dll", EntryPoint = "MakePartitionList", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern int MakePartitionList(string lpFn, string lpszPassword, ref int lpdwNbPartFound, ref int dwNbFat32Found, int dwArraySize,ref PARTDESCArray pdarr);
    // public static extern bool MakePartitionList(string lpFn, string lpszPassword, ref int lpdwNbPartFound, ref int dwNbFat32Found, int dwArraySize, int fooav);
    //public static extern bool MakePartitionList(string lpFn, string lpszPassword, ref int lpdwNbPartFound, ref int dwNbFat32Found, int dwArraySize, int fooav);
    //public static extern bool MakePartitionList(int a, int b, int c, int d, int e, int f);






    //DWORD WIMAAPI GetNumberPhysicalDisk();
    [DllImport("wimadll.dll", EntryPoint = "GetNumberPhysicalDisk", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern uint GetNumberPhysicalDisk();

    

    //BOOL WIMAAPI GetPhysicalDiskSizeAndInfo(DWORD dwDisk,LPDWORD lpdwSizeLow,LPDWORD lpdwSizeHigh,
    //                             LPBOOL lpfRemovable,
    //                             LPTSTR lpszUnitName,DWORD dwUnitNameSize);



    [DllImport("wimadll.dll", EntryPoint = "GetPhysicalDiskSizeAndInfo", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool GetPhysicalDiskSizeAndInfo(uint numdisk, ref uint lpdwSizeLow, ref uint lpdwSizeHigh, ref bool fIsRemovable,
         [MarshalAs(UnmanagedType.LPStr)] System.Text.StringBuilder lpBuf, uint uiMaxSize);


    
    //BOOL WIMAAPI CreatePhysicalDiskImage(HWND hWnd,DWORD dwDisk,LPCSTR lpFn,PHYSICALDISKIMAGEFORMAT PhysFormat);
    [DllImport("wimadll.dll", EntryPoint = "CreatePhysicalDiskImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool CreatePhysicalDiskImage(IntPtr hWnd, uint dwDisk, string lpFn, PHYSICALDISKIMAGEFORMAT PhysFormat);


    //BOOL WIMAAPI CreatePhysicalDiskImageCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                                   DWORD dwDisk,LPCSTR lpFn,PHYSICALDISKIMAGEFORMAT PhysFormat);
    [DllImport("wimadll.dll", EntryPoint = "CreatePhysicalDiskImageCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool CreatePhysicalDiskImageCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, uint dwDisk, string lpFn, PHYSICALDISKIMAGEFORMAT PhysFormat);



    //BOOL WIMAAPI RestorePhysicalDiskImage(HWND hWnd,DWORD dwDisk,LPCSTR szFile);
    [DllImport("wimadll.dll", EntryPoint = "RestorePhysicalDiskImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RestorePhysicalDiskImage(IntPtr hWnd, uint dwDisk, string lpFn);


    //BOOL WIMAAPI RestorePhysicalDiskImageCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                                        DWORD dwDisk,LPCSTR szFile);
    [DllImport("wimadll.dll", EntryPoint = "RestorePhysicalDiskImageCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RestorePhysicalDiskImageCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, uint dwDisk, string lpFn);
    


    //BOOL WIMAAPI ConvertVhdImgFileName(HWND hWnd,LPCSTR szFileRead,LPCSTR lpFilenameParamWrite,PHYSICALDISKIMAGEFORMAT PhysFormat);
    [DllImport("wimadll.dll", EntryPoint = "ConvertVhdImgFileName", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ConvertVhdImgFileName(IntPtr hWnd, string lpFnRead, string lpFnWrite, PHYSICALDISKIMAGEFORMAT PhysFormat);



    //BOOL WIMAAPI ConvertVhdImgFileNameCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                                     LPCSTR szFileRead,LPCSTR lpFilenameParamWrite,PHYSICALDISKIMAGEFORMAT PhysFormat);
    [DllImport("wimadll.dll", EntryPoint = "ConvertVhdImgFileNameCB", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool ConvertVhdImgFileNameCB(IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam, string lpFnRead,string lpFnWrite,PHYSICALDISKIMAGEFORMAT PhysFormat);





    

    //BOOL WIMAAPI RebuildPartitionAndFormat(DWORD dwDisk,DWORD dwNbPart,DWORD dwNumActivate,
    //                          const PARTITION_CREATION_INFO* lpPartRequestInfo);


    [DllImport("wimadll.dll", EntryPoint = "RebuildPartitionAndFormat", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RebuildPartitionAndFormat(uint disk, uint nbPart, uint numActivate,
                                    ref PARTITION_CREATION_INFO partRequestInfo);

    //BOOL WIMAAPI RebuildPartitionAndFormatImage(LPCSTR lpFileName,DWORD dwNbPart,DWORD dwNumActivate,
    //                          const PARTITION_CREATION_INFO* lpPartRequestInfo);

    [DllImport("wimadll.dll", EntryPoint = "RebuildPartitionAndFormatImage", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RebuildPartitionAndFormatImage(string lpFileName, uint nbPart, uint numActivate,
                                    ref PARTITION_CREATION_INFO partRequestInfo);

    //BOOL WIMAAPI RebuildPartitionAndFormatAndAdapt(DWORD dwDisk,DWORD dwNbPart,DWORD dwNumActivate,
    //                          const PARTITION_CREATION_INFO* lpPartRequestInfo,

    //                        DWORD dwNumPartitionAdaptIma,HIMA hImaWriteResize,
    //                        HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                        LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,CHOICEAPP caWrite);


    [DllImport("wimadll.dll", EntryPoint = "RebuildPartitionAndFormatAndAdapt", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RebuildPartitionAndFormatAndAdapt(uint disk, uint nbPart, uint numActivate,
                                    ref PARTITION_CREATION_INFO partRequestInfo,
                                    uint numPartitionAdaptIma, IntPtr hImaWriteResize,
                                    IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam,
                                    ref uint dwTotalLow, ref uint dwTotalHigh, ChoiceApp ca);



    
    //BOOL WIMAAPI RebuildPartitionAndFormatImageAndAdapt(LPCSTR lpFileName,DWORD dwNbPart,DWORD dwNumActivate,
    //                          const PARTITION_CREATION_INFO* lpPartRequestInfo,

    //                          DWORD dwNumPartitionAdaptIma,HIMA hImaWriteResize,
    //                          HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    //                          LPDWORD lpdwTotal,LPDWORD lpdwTotalHigh,CHOICEAPP caWrite);


    [DllImport("wimadll.dll", EntryPoint = "RebuildPartitionAndFormatImageAndAdapt", ExactSpelling = true, CharSet = CharSet.Ansi, SetLastError = true)]
    public static extern bool RebuildPartitionAndFormatImageAndAdapt(string lpFileName, uint nbPart, uint numActivate,
                                    ref PARTITION_CREATION_INFO partRequestInfo,
                                    uint numPartitionAdaptIma, IntPtr hImaWriteResize,
                                    IntPtr hWnd, WimCB pEventNotifCallBack, IntPtr lpUsrParam,
                                    ref uint dwTotalLow, ref uint dwTotalHigh, ChoiceApp ca);


    #endregion
}
