/* sample written by Nathan Moinvaziri [nmoinvaziri@yahoo.com] */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <string.h>

#include <windows.h>

#include "wimadll.h"

DWORD WINAPI EventNotif (DWORD dwEvent,
                                            DWORD dwEventParam,DWORD dwWin32Err,
                                            LPVOID lpParam,LPVOID lpUsrParam)
{
    if (dwEvent == DWEV_PROGRESSPERCENT)
        printf("\x08\x08\x08\x08%02u %%",dwEventParam);
    return 0;
}

int main(int argc,char *argv[])
{
    int iRet=0;
    HIMA hIma;

    printf("AdaptGeom WinImage SDK sample\n");
    if (argc<3)
    {
        printf("AdaptGeom\n" \
            "Usage : AdaptGeom <imagefile> <drive> [ALL]\n");
    }
    else
    {
      hIma = OpenLargeImageFile(NULL,argv[1],0,0,TRUE);
      if (hIma==NULL)
      {
          printf("Unable to open %s\n",argv[1]);
          iRet=2;
      }
      else
      {
          char cDrive=*(argv[2]);
          DWORD dwTotalLow=0;
          DWORD dwTotalHigh=0;
          BOOL fGeomIncompatible=FALSE;
          CHOICEAPP caWrite=USED;//ALL;

          if ((cDrive>='A') && (cDrive<='Z'))
              cDrive -= 0;
          if ((cDrive>='a') && (cDrive<='z'))
              cDrive -= ('a'-'A');
          printf("try write to %c:",cDrive);
          if (argc>=4)
          {
              if (lstrcmpi(argv[3],"ALL")==0)
              {
                  caWrite=ALL;
                  printf(" ALL selected (erase end of partition");
              }
          }
          printf("\n");


          printf("....");
          BOOL fRes=WimLargeWriteLargeImaCBEx(hIma,NULL,EventNotif,NULL,cDrive,&dwTotalLow,&dwTotalHigh, caWrite,FALSE,TRUE,&fGeomIncompatible);
          printf("\nResult : %s, dwTotal=0x%08x%08x bytes, GeomIncompatible=%s\n",
              fRes ? "true":"false",dwTotalHigh,dwTotalLow,fGeomIncompatible? "true":"false");
          if (!fRes)
              iRet=1;

          DeleteIma(hIma);
      }
    }
	
	return iRet;
}
