using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WinImageSample
{
    public partial class Form1 : Form
    {

        private WinImage.ISOImage ISOMain = null;
        public Form1()
        {
            InitializeComponent();
        }

        private void miOpen_Click(object sender, EventArgs e)
        {
            if (ofdImage.ShowDialog(this) == DialogResult.OK)
            {
                CloseImage();
                ISOMain = new WinImage.ISOImage(ofdImage.FileName);
                if (ISOMain.LastError.ErrorType == WinImage.WinImageError.EType.None)
                {
                    ISOMain.Overwrite = WinImage.OverwriteType.PROMPT;
                    ISOMain.Silent = false;
                    ISOMain.DisplayImage(this.tsTree);
                    miClose.Enabled = true;
                }
                else
                {
                    MessageBox.Show("Unable To Load Image File:\n" + ISOMain.LastError.ErrorSource);
                }
            }
        }

        private void miClose_Click(object sender, EventArgs e) { CloseImage(); }

        private void miExtract_Click(object sender, EventArgs e)
        {
            if (fbdExtract.ShowDialog(this) == DialogResult.OK)
            {
                if (ISOMain.ExtractFiles(fbdExtract.SelectedPath))
                {
                    MessageBox.Show("Extraction Completed Successfully.");
                }
                else
                {
                    MessageBox.Show("Extraction Failded!\n" + ISOMain.LastError.ErrorCause);
                }
            }

        }

        private void miExit_Click(object sender, EventArgs e)
        {
            CloseImage();
            Application.Exit();
        }

        private void tsTree_AfterCheck(object sender, TreeViewEventArgs e)
        {
            if (e.Action == TreeViewAction.ByKeyboard || e.Action == TreeViewAction.ByMouse)
            {
                ISOMain.Files[e.Node.Name].Selected = e.Node.Checked;
            }
            miExtract.Enabled = ((ISOMain.SelectedFiles + ISOMain.SelectedFolders) > 0);
        }

        private void CloseImage()
        {
            if (ISOMain != null)
            {
                ISOMain.Dispose();
                ISOMain = null;
            }
            tsTree.Nodes.Clear();
            miClose.Enabled = false;
            miExtract.Enabled = false;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e) { CloseImage(); }
    }
}