' Visual Basic 7.x (.net on Visual Studio 2002/2003 and later ) header
Option Strict Off
Option Explicit On
Module Wimadll


    Public Const MAXLFN As Short = 256

    Public Const SORT_NONE As Short = 72
    Public Const SORT_NAME As Short = 73
    Public Const SORT_EXT As Short = 74
    Public Const SORT_SIZE As Short = 75
    Public Const SORT_DATE As Short = 76

    Public Const CDM_ROOT As Short = 50
    Public Const CDM_UPPER As Short = 51
    Public Const CDM_ENTRY As Short = 52

    'Values for Floppy Density
    Public Const FLOPPY_160K As Short = 0
    Public Const FLOPPY_180K As Short = 1
    Public Const FLOPPY_320K As Short = 2
    Public Const FLOPPY_360K As Short = 3
    Public Const FLOPPY_720K As Short = 4
    Public Const FLOPPY_1200K As Short = 5
    Public Const FLOPPY_1440K As Short = 6
    Public Const FLOPPY_2880K As Short = 7
    Public Const FLOPPY_DMF2048K As Short = 8
    Public Const FLOPPY_DMF1024K As Short = 9
    Public Const FLOPPY_1680K As Short = 10


    ' value for CaRead or CaCompare or CaWrite or CaFormat
    Public Const FL_NOTHING As Short = 0
    Public Const FL_USED As Short = 1
    Public Const FL_ALL As Short = 2
    Public Const FL_BEGINFLOPPY As Short = 3

    Structure DIRINFO
        <VBFixedArray(8)> Dim nom() As Byte
        <VBFixedArray(3)> Dim ext() As Byte
        <VBFixedArray(13)> Dim szCompactName() As Byte
        Dim bAttr As Byte
        Dim dir_CreateMSec As Byte
        Dim dir_CreateDate As Short
        Dim DosTime As Short
        Dim DosDate As Short
        Dim fIsSubDir As Integer
        Dim fSel As Integer 'Boolean
        Dim fLfnEntry As Integer
        Dim dwSize As Integer
        Dim uiPosInDir As Integer
        Dim dwLocalisation As Integer
        Dim dwTrueSize As Integer
        <VBFixedArray(MAXLFN)> Dim longname() As Byte
        Dim dir_CreateTime As Short
        Dim dir_LastAccessDate As Short

        'UPGRADE_TODO: "Initialize" must be called to initialize instances of this structure. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1026"'
        Public Sub Initialize()
            'UPGRADE_WARNING: Lower bound of array nom was changed from 1 to 0. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1033"'
            ReDim nom(8)
            'UPGRADE_WARNING: Lower bound of array ext was changed from 1 to 0. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1033"'
            ReDim ext(3)
            'UPGRADE_WARNING: Lower bound of array szCompactName was changed from 1 to 0. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1033"'
            ReDim szCompactName(13)
            'UPGRADE_WARNING: Lower bound of array longname was changed from 1 to 0. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1033"'
            ReDim longname(MAXLFN)
        End Sub
    End Structure

    Structure ASPIINQUIRYTAB
        Dim dwSizeStruct As Integer
        Dim dwHost As Integer
        Dim dwTargetID As Integer
        Dim dwTargetType As Integer
        <VBFixedArray(32)> Dim szDeviceName() As Byte

        'UPGRADE_TODO: "Initialize" must be called to initialize instances of this structure. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1026"'
        Public Sub Initialize()
            'UPGRADE_WARNING: Lower bound of array szDeviceName was changed from 1 to 0. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1033"'
            ReDim szDeviceName(32)
        End Sub
    End Structure

    ' // for ExtractFile and InjectFile, in event DWEV_PROGRESSPERCENT lpParam contain a
    ' //    PROGRESSFILE_SUPINFO structure

    Structure PROGRESSFILE_SUPINFO
        Dim dwSizeStruct As Integer
        Dim dwCurrentPos As Integer
        Dim dwReserved1 As Integer
        Dim dwTotalSize As Integer
        Dim dwReserved2 As Integer
        Dim lpszName As String
        Dim lpszFullName As String
    End Structure

    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    ' Callback stuff

    Public Delegate Function WimCB(ByVal dwEvent As Integer, _
                                   ByVal dwEventParam As Integer, _
                                   ByVal dwWin32Err As Integer, _
                                   ByVal lpParam As Integer, _
                                   ByVal lpUserParam As Integer) As Integer

    '// dwEvent contain a DWEV_xxx value, see below
    '// lpUsrParam contain user param gived to function
    '
    Public Const DWEV_ERRORSUPINFO As Integer = &H7FFF0001
    '#define DWEV_ERRORSUPINFO       ((DWORD)0x7fff0001)
    '// IO Error with supplemental info (in ReadFloppy and WriteFloppy)
    '// dwEventParam = WinImage error number (see below), Bios like error number
    '// dwWin32Err : Win32 error number, like GetLastError()
    '// lpParam * pointer to an ERROR_SUPINFO structure
    '// return value : IDRETRY (4), IDABORT (3), IDIGNORE (5) or  IDCANCEL (2)
    '//   dwEventParam = 0x01         "Internal error 1\n"
    '//   dwEventParam = 0x02         "Address mark not found"
    '//   dwEventParam = 0x03         "Diskette is write-protected"
    '//   dwEventParam = 0x04         "Sector not found"
    '//   dwEventParam = 0x08         "DMA overflow"
    '//   dwEventParam = 0x09         "Internal error 9"
    '//   dwEventParam = 0x10         "Error in reading"
    '//   dwEventParam = 0x20         "Error in floppy adapter"
    '//   dwEventParam = 0x40         "Track not found"
    '//   dwEventParam = 0x80         "There is no floppy in the drive"
    '//   dwEventParam = 0x100        "Floppies do not match"
    '
    '
    Public Const DWEV_ERRORWIN32 As Integer = &H7FFF0002
    '#define DWEV_ERRORWIN32         ((DWORD)0x7fff0002)
    '// Win32 IO Error in ReadFloppy and WriteFloppy and ReadLargeIma and WriteLargeIma
    '// dwEventParam = WinImage error number (see DWEV_ERRORSUPINFO), Bios like error number or 0
    '// dwWin32Err : Win32 error number, like GetLastError()
    '// return value : IDRETRY to retry (when possible)
    '// elsewhere (IDCANCEL or 0) to stop
    '
    '
    Public Const DWEV_ERRORCANTACCESS As Integer = &H7FFF0003
    '#define DWEV_ERRORCANTACCESS    ((DWORD)0x7fff0003)
    '// in ReadFloppy* and WriteFloppy*
    '// "Drive cannot be accessed - Check to see if another application is using it"
    '// return value not used
    '
    Public Const DWEV_ERRORDRIVEEMPTY As Integer = &H7FFF0004
    '#define DWEV_ERRORDRIVEEMPTY    ((DWORD)0x7fff0004)
    '// in ReadFloppy* and WriteFloppy*
    '// "There is no floppy in the drive"
    '// return value not used
    '
    Public Const DWEV_ERROR_NOT_MATCH As Integer = &H7FFF0005
    '#define DWEV_ERROR_NOT_MATCH    ((DWORD)0x7fff0005)
    '// in ReadFloppy*
    '// "Floppies do not match"
    '// return value not used
    '
    Public Const DWEV_UNSTDFMT As Integer = &H7FFF0006
    '#define DWEV_UNSTDFMT           ((DWORD)0x7fff0006)
    '// in ReadFloppy* and WriteFloppy*
    '// "The current image format differs from the standard format for this disk drive"
    '// return value : IDOK (1) to continue, IDCANCEL to abort
    '
    Public Const DWEV_UNSUPFMT As Integer = &H7FFF0007
    '#define DWEV_UNSUPFMT           ((DWORD)0x7fff0007)
    '// in WriteFloppy* and WriteLargeIma
    '// "The current image format is not supported by the disk drive"
    '// return value not used
    '
    Public Const DWEV_DIFFTYPEDISK As Integer = &H7FFF0008
    '#define DWEV_DIFFTYPEDISK       ((DWORD)0x7fff0008)
    '// in WriteFloppy*
    '// "Disk and image formats do not match\nDo you want to reformat it?"
    '// return IDYES (6) or IDNO (7)
    '
    Public Const DWEV_DISKHASDATA As Integer = &H7FFF0009
    '#define DWEV_DISKHASDATA        ((DWORD)0x7fff0009)
    '// in WriteFloppy*
    '// "Disk is not empty, all data on your disk will be lost!\nDo you want to continue?"
    '// return IDYES (6) or IDNO (7)
    '
    Public Const DWEV_PROGRESSPERCENT As Integer = &H7FFF000A
    '#define DWEV_PROGRESSPERCENT    ((DWORD)0x7fff000a)
    '// Give % progress info
    '// dwEventParam between 0 and 100
    '// for ExtractFile and InjectFile, lpParam contain a PROGRESSFILE_SUPINFO structure
    '// return value : IDCANCEL (2) to stop, 0 to continue
    '
    Public Const DWEV_ERRORASPI As Integer = &H7FFF000B
    '#define DWEV_ERRORASPI          ((DWORD)0x7fff000b)
    '// Aspi error in WimLargeReadAspiCDImage*
    '// dwEventParam contain first sector number of range error
    '// return value : IDABORT, IDRETRY or IDIGNORE
    '
    Public Const DWEV_ERRORWRITEIMAGEFILE As Integer = &H7FFF000C
    '#define DWEV_ERRORWRITEIMAGEFILE    ((DWORD)0x7fff000c)
    '// error in writing image file in WimLargeReadAspiCDImage*
    '// dwWin32Err : Win32 error number, like GetLastError()
    '
    '
    Public Const DWEV_ERRORIOCTL As Integer = &H7FFF000D
    '#define DWEV_ERRORIOCTL             ((DWORD)0x7fff000d)
    '// IOCTL error when reading Disk partition under Win9x
    '// dwEventParam is Int25/26 error value
    '// return value : IDCANCEL or IDRETRY
    '
    Public Const DWEV_ROOTREADDONE As Integer = &H7FFF000E
    '// when reading FAT image, say when the root is read
    '// return value is not used

    Public Const ON_FORMAT As Short = 0
    Public Const ON_READ As Short = 1
    Public Const ON_WRITE As Short = 2
    Public Const ON_COMPARE As Short = 3

    'typedef struct
    '{
    '    DWORD dwSizeStruct;
    '    LOCATEERROR LocErr;
    '    DWORD dwHead;
    '    DWORD dwTrack;

    '    DWORD dwPosLow;
    '    DWORD dwPosHigh;
    '    DWORD dwStyleAnswer;

    '    DWORD dwErrNumber;
    '    LPCTSTR lpszErrorText;
    '} ERROR_SUPINFO;

    Structure ERROR_SUPINFO
        Dim dwSizeStruct As Integer
        Dim LocErr As Integer
        Dim dwHead As Integer
        Dim dwTrack As Integer
        Dim dwPosLow As Integer
        Dim dwPosHigh As Integer
        Dim dwStyleAnswer As Integer
        Dim dwErrNumber As Integer
        Dim lpszErrorTest As String
    End Structure

    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''



    ' CreateMemFatHima : Create an Image Object.
    ' you need call ReadImaFile, ReadFloppy or MakeEmptyImage
    Declare Function CreateMemFatHima Lib "wimadll.dll" () As Integer

    ' CreateMemHfsHima : Create an Image Object for Mac floppy.
    ' you need call ReadImaFile, ReadFloppy
    ' extract, inject... cannot be used
    Declare Function CreateMemHfsHima Lib "wimadll.dll" () As Integer

    ' CreateCDIsoIma : Create an Image Object by loading CDRom ISO image
    '  lpFn : Filename of .ISO file
    '  inject,...cannot be used
    Declare Function CreateCDIsoIma Lib "wimadll.dll" (ByVal lpFn As String) As Integer




    ' OpenFatLargeFile : Open a large disk image (hard disk image)
    '  hWnd : parent window for progress window
    '  lpFn : FileName
    '  dwPosFileBegin : position in file (usualy 0)
    '  dwPosFileBegin : position in file, high (usualy 0), for file > 4GB
    '  fReadOnlyAsked : if the file must be opened in read-only mode
    'HIMA WIMAAPI OpenFatLargeFile(HWND hWnd,LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);
    'HIMA WIMAAPI OpenFatLargeFileCB(HWND hWnd,EVENTNOTIFCALLBACK pEventNotifCallBack,LPVOID lpUsrParam,
    '                                LPCSTR lpFn,DWORD dwPosInFile,DWORD dwPosInFileHigh,BOOL fReadOnlyAsked);

    Declare Function OpenFatLargeFile Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal lpFn As String, ByVal dwPosInFile As Integer, ByVal dwPosInFileHigh As Integer, ByVal fReadOnlyAsked As Boolean) As Integer

    Declare Function OpenFatLargeFileCB Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal lpFn As String, ByVal dwPosInFile As Integer, ByVal dwPosInFileHigh As Integer, ByVal fReadOnlyAsked As Boolean) As Integer

    ' DeleteIma : Delete an Image Object.
    Declare Sub DeleteIma Lib "wimadll.dll" (ByVal Ima As Integer)


    ' ReadImaFile: Read an image file (.IMA or .IMZ)
    '  hWnd : parent window for progress window
    '  lpFn : FileName
    '  lpfCompr : pointer to Boolean (will receive TRUE if file is compressed)
    '  dwPosFileBegin : position in file (usualy 0, except in WLZ)
    Declare Function ReadImaFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal lpFn As String, ByRef lpfCompr As Boolean, ByVal dwPosFileBegin As Integer) As Boolean
    Declare Function ReadImaFileEx Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal lpFn As String, ByRef lpfCompr As Boolean, ByVal dwPosFileBegin As Integer, ByVal lpszPassword As String) As Boolean
    Declare Function ReadImaFileExCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal lpFn As String, ByRef lpfCompr As Boolean, ByVal dwPosFileBegin As Integer, ByVal lpszPassword As String) As Boolean

    ' WriteImaFile : WriteCompressed image
    '  hWnd : parent window for progress window
    '  lpFn : FileName
    '  fTruncate : TRUE if you want truncate unused part of image
    '  fCompress : TRUE if you want compress
    '  iLevelCompress : used is fCompress is TRUE, level of compress (1 to 9)
    '  dwPosBeginWrite : position in file (usualy 0)
    '  lpNameInCompr : alternate name in compressed file (can be NULL)
    Declare Function WriteImaFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal lpFn As String, ByVal fTruncate As Boolean, ByVal fCompr As Boolean, ByVal iLevelCompress As Integer, ByVal dwPosBeginWrite As Integer, ByVal lpNameInCompr As String) As Boolean

    Declare Function WriteImaFileEx Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal lpFn As String, ByVal fTruncate As Boolean, ByVal fCompr As Boolean, ByVal iLevelCompress As Integer, ByVal dwPosBeginWrite As Integer, ByVal lpNameInCompr As String, ByVal lpszPassword As String) As Boolean

    Declare Function WriteImaFileExCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal lpFn As String, ByVal fTruncate As Boolean, ByVal fCompr As Boolean, ByVal iLevelCompress As Integer, ByVal dwPosBeginWrite As Integer, ByVal lpNameInCompr As String, ByVal lpszPassword As String) As Boolean



    '  ReadFloppy : Read a floppy
    '  hWnd : parent window for progress window
    '  bFloppy : Floppy to read (0 for A:)
    '  caRead : USED, or ALL (ALL if you want read unused part of floppy)
    ' BOOL WIMAAPI ReadFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caRead);
    Declare Function ReadFloppy Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal bFloppy As Byte, ByVal caRead As Integer) As Boolean

    Declare Function ReadFloppyCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal bFloppy As Byte, ByVal caRead As Integer) As Boolean

    ' WriteFloppy : Write a floppy
    '  hWnd : parent window for progress window
    '  bFloppy : Floppy to write (0 for A:)
    '  caFormat : NOTHING or ALL (ALL for format)
    '  caWrite : USED or ALL
    '  caCompare : NOTHING, USED or ALL
    '  fCheckDiskBeforeWrite : if you want check disk is empty
    'BOOL WIMAAPI WriteFloppy(HIMA hIma,HWND hWnd,BYTE bFloppy,CHOICEAPP caFormat,
    '                        CHOICEAPP caWrite,CHOICEAPP caCompare,
    '                        BYTE fCheckDiskBeforeWrite);alias
    Declare Function WriteFloppy Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal bFloppy As Byte, ByVal caFormat As Integer, ByVal caWrite As Integer, ByVal caCompare As Integer, ByVal fCheckDiskBeforeWrite As Byte) As Boolean

    Declare Function WriteFloppyCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal bFloppy As Byte, ByVal caFormat As Integer, ByVal caWrite As Integer, ByVal caCompare As Integer, ByVal fCheckDiskBeforeWrite As Byte) As Boolean


    ' Create a directory in the image
    '  lpDir : Directory name
    ' BOOL WIMAAPI MkDir(HIMA hIma,LPSTR lpDir);
    'UPGRADE_NOTE: MkDir was upgraded to MkDir_Renamed. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1061"'
    Declare Function MkDir_Renamed Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpDir As String) As Boolean

    ' Change current directory by name
    '  lpDir : Directory name
    ' BOOL WIMAAPI ChszDir(HIMA hIma,LPSTR lpDir);
    Declare Function ChszDir Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpDir As String) As Boolean

    ' Change current directory by mode
    '  bMode : CDM_ROOT or CDM_UPPER (equiv. to cd \ and cd ..)
    ' BOOL WIMAAPI ChDir(HIMA hIma,BYTE bMode);
    'UPGRADE_NOTE: ChDir was upgraded to ChDir_Renamed. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1061"'
    Declare Function ChDir_Renamed Lib "wimadll.dll" (ByVal Ima As Integer, ByVal bMode As Byte) As Boolean

    ' InjectFile : Inject a file in floppy
    '  lpFn : file to inject
    '  lpDwSize : Pointer to DWORD that will receive the size. Can be NULL.
    '  lpTooBig : Pointer to BOOL, become TRUE if file too big to be injected
    '      (if InjectFile return FALSE). Can be NULL.
    '  lpNameWhenInjected : if not NULL, contain a new name in the image
    '      (if the file must have another name when injected). Can be NULL.
    '    for the CB version, the only event is DWEV_PROGRESSPERCENT
    'BOOL WIMAAPI InjectFile(HIMA hIma,LPSTR lpFn,
    '                        LPDWORD lpDwSize,LPBOOL lpTooBig,
    '                        LPSTR lpNameWhenInjected);
    Declare Function InjectFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpFn As String, ByRef lpdwSize As Integer, ByRef lpTooBig As Boolean, ByVal lpNameWhenInjected As String) As Boolean
    Declare Function InjectFileCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal lpFn As String, ByRef lpdwSize As Integer, ByRef lpTooBig As Boolean, ByVal lpNameWhenInjected As String) As Boolean


    ' MakeEmptyImage : make an empty image
    ' iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K
    '                  0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-))
    'BOOL WIMAAPI MakeEmptyImage(HIMA hIma,int iNoTypeDisk);
    Declare Function MakeEmptyImage Lib "wimadll.dll" (ByVal Ima As Integer, ByVal iNoTypeDisk As Integer) As Boolean



    Declare Function MakeEmptyImageEx Lib "wimadll.dll" (ByVal Ima As Integer, _
                        ByVal lpszBootSectorGeom As String,ByVal lpszBootSectorCode As String) As Boolean



    Declare Function BuildImaNewFormat Lib "wimadll.dll" (ByVal hOldIma As Integer,fNewTypeDisk As Boolean,ByVal iNoTypeDisk As Integer) As Integer
    Declare Function BuildImaNewFormatEx Lib "wimadll.dll" (ByVal hOldIma As Integer,ByVal hNewIma As Integer, _
                                        ByVal lpszBootSectForGeometry As String,ByVal fDiscardOldIma As Boolean) As Boolean

    Declare Function BuildImaNewFormatExCB Lib "wimadll.dll" (ByVal hOldIma As Integer,ByVal hNewIma As Integer, _
                                        ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, _
                                        ByVal lpszBootSectForGeometry As String,ByVal fDiscardOldIma As Boolean) As Boolean
    ' InitWimaSdk : Init the DLL and use hinstdll for resource
    '#define DEBENUSTD "ENU"
    ' #define BASEENUSTD (10000)
    Const DEBENUSTD As String = "ENU"
    Const BASEENUSTD As Short = (10000)
    ' BOOL WIMAAPI InitWimaSdk(HINSTANCE hinstdll,LPSTR lpDeb,WORD wBase);
    Declare Function InitWimaSdk Lib "wimadll.dll" (ByVal hinstdll As Integer, ByVal lpDeb As String, ByVal wBase As Short) As Boolean

    ' GetCurDir : Get the name of current directory
    '  lpBuf : buffer that will receive the name
    '  uiMaxSize : the size of buffer
    ' BOOL WIMAAPI GetCurDir(HIMA hIma,LPSTR lpBuf,UINT uiMaxSize);
    Declare Function GetCurDir Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpBuf As String, ByVal uiMaxSize As Integer) As Boolean

    ' GetNbEntryCurDir : Get the number of entry of cur directory
    ' DWORD WIMAAPI GetNbEntryCurDir(HIMA hIma);
    Declare Function GetNbEntryCurDir Lib "wimadll.dll" (ByVal Ima As Integer) As Integer

    ' GetDirInfo : Get info about the entry of cur directory
    '  LPDIRINFO : array of DIRINFO that will receive the info
    '                  (use GetNbEntryCurDir for know the size needed)
    '  bSort :     specify how the file must be sort
    '          (SORT_NONE, SORT_NAME, SORT_EXT, SORT_SIZE or SORT_DATE)
    ' BOOL WIMAAPI GetDirInfo(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);
    '' GetDirInfo and Sort MUST BE CHECKED IN BASIC!!!
    'UPGRADE_WARNING: Structure DIRINFO may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    Declare Function GetDirInfo Lib "wimadll.dll" (ByVal Ima As Integer, ByRef di As DIRINFO, ByVal bSort As Byte) As Boolean

    ' Sort : Resort the array obtained by GetDirInfo
    'BOOL WIMAAPI Sort(HIMA hIma,LPDIRINFO lpdi,BYTE bSort);
    'UPGRADE_WARNING: Structure DIRINFO may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    Declare Function Sort Lib "wimadll.dll" (ByVal Ima As Integer, ByRef di As DIRINFO, ByVal bSort As Byte) As Boolean

    ' GetLabel : Get the label of Image
    '  lpBuf : will receive the label
    'BOOL WIMAAPI GetLabel(HIMA hIma,LPSTR lpBuf);
    Declare Function GetLabel Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpDir As String) As Boolean


    ' SetLabel : Set the label of Image
    '  lpBuf : contain the new label
    ' BOOL WIMAAPI SetLabel(HIMA hIma,LPSTR lpBuf);
    Declare Function SetLabel Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpDir As String) As Boolean

    ' ExtractFile : Extract one file
    '  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
    '                  the file
    '  lpPath :    Path where extract the file
    '  lpFullName: will receive the exact full name of created file. Can be NULL
    'BOOL WIMAAPI ExtractFile(HIMA hIma,UINT uiPosDir,LPSTR lpPath,LPSTR lpFullName);
    ' for the CB version, the only event is DWEV_PROGRESSPERCENT
    Declare Function ExtractFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal uiPosDir As Integer, ByVal lpPath As String, ByVal lpFullName As String) As Boolean
    Declare Function ExtractFileCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal uiPosDir As Integer, ByVal lpPath As String, ByVal lpFullName As String) As Boolean


    ' CheckSpaceForFile : Check you've space for inject a file of dwSize bytes
    ' BOOL WIMAAPI CheckSpaceForFile(HIMA hIma,DWORD dwSize);
    Declare Function CheckSpaceForFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal dwSize As Integer) As Boolean

    ' to know if an inject is possible but need replace
    '  lpFn : contain the name of file to be injected
    '  lpDwSize : will receive the size of old file with same name. Can be NULL
    '  lpNameWhenInjected : if not NULL, contain a new name in the image
    '  lpShortName : will receive the short (8) name of file in image. Can be NULL
    '  lpShortExt  : will receive the short (3) ext of file in image. Can be NULL
    '      (if the file must have another name when injected)
    'BOOL WIMAAPI IfInjectPossibleButNeedReplace(HIMA hIma,LPSTR lpFn,
    '         LPDWORD lpDwSize,LPSTR lpShortName,
    '         LPSTR lpShortExt,LPSTR lpNameWhenInjected);
    Declare Function IfInjectPossibleButNeedReplace Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpFn As String, ByRef lpdwSize As Integer, ByVal lpShortName As String, ByVal lpShortExt As String, ByVal lpNameWhenInjected As String) As Boolean

    ' RmDir : Remove a directory
    '  unPosDir :  The uiPosInDir fields in DIRINFO structure that describe
    '                  the file
    'BOOL WIMAAPI RmDir(HIMA hIma,UINT uiPosDir);
    'UPGRADE_NOTE: RmDir was upgraded to RmDir_Renamed. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1061"'
    Declare Function RmDir_Renamed Lib "wimadll.dll" (ByVal Ima As Integer, ByVal uiPosDir As Integer) As Boolean

    ' DeleteFileNameExt
    ' Delete a file in the image
    ' BOOL WIMAAPI DeleteFileNameExt(HIMA hIma,LPSTR lpNom,LPSTR lpExt,BOOL fRealDel);
    '     for filling lpNom and lpExt, use data obtained from GetDirInfo
    '   lpNom : pointer to array of 8 chars (name of 8.3 name, use DIRINFO.nom)
    '   lpExt : pointer to array of 3 chars (ext  of 8.3 name, use DIRINFO.ext)
    '   fRealDel : TRUE to really delete, FALSE to only test if delete is possible

    Declare Function DeleteFileNameExt Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpNom As String, ByVal lpExt As String, ByVal fRealDel As Boolean) As Boolean


    Public Const ERRINFO_MOVEFILE_DESTINATIONEQUALSOURCE As Integer = &H80000001
    Public Const ERRINFO_MOVEFILE_DESTINATIONSUBFOLERDEPL As Integer = &H80000002

    'BOOL WIMAAPI MoveFileToDir(HIMA hIma,LPCSTR lpName,LPCSTR lpExt,LPCSTR lpszDestDir,
    '                           LPBOOL lpfReplaceNeeded,BOOL fDoRealMove,BOOL fDoReplaceIfNeeded,
    '                           LPDWORD lpdwErrInfo);
    Declare Function MoveFileToDir Lib "wimadll.dll" (ByVal Ima As Integer, _
                                    ByVal lpName As String, ByVal lpExt As String, _
                                    ByVal lpszDestDir As String, lpfReplaceNeeded As Boolean, _
                                    ByVal fDoRealMove As Boolean, ByVal fDoReplaceIfNeeded As Boolean, _
                                    lpdwErrInfo As Integer) As Boolean

    ' RenameFile :    Rename one file
    '  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
    '                  the file
    '  lpNewLongName: The new name of the file
    ' BOOL RenameFile(HIMA hIma,UINT uiPosDir,LPCSTR lpNewLongName);
    Declare Function RenameFile Lib "wimadll.dll" (ByVal Ima As Integer, ByVal uiPosDir As Integer, ByVal lpNewLongName As String) As Boolean

    ' ChangeDateAndAttribute :    Change the date and attribute of a File
    '  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe
    '                  the file
    '  *lpbNewAttr:   Contain the new attribute of the file (or NULL to no change)
    '  *lpNewDosDate,
    '  *lpNewDosTime: Contain the Modified Date and Time (or NULL to no change)
    '  *lpbNewdir_CreateMSec,*lpwNewdir_CreateTime,*lpwNewdir_CreateDate
    '                 Contain the Created Date and Time (or NULL to no change)
    '  *lpwNewdir_LastAccessDate : Contain the Last Access Date (or NULL...)
    ' BOOL ChangeDateAndAttribute(HIMA hIma,UINT uiPosDir,LPBYTE lpbNewAttr,
    '                                     LPWORD lpNewDosDate,LPWORD lpNewDosTime,
    '                                     LPBYTE lpbNewdir_CreateMSec,
    '                                     LPWORD lpwNewdir_CreateTime,LPWORD lpwNewdir_CreateDate,
    '                                     LPWORD lpwNewdir_LastAccessDate);
    Declare Function ChangeDateAndAttribute Lib "wimadll.dll" (ByVal Ima As Integer, ByVal uiPosDir As Integer, ByRef NewAttr As Byte, ByRef NewDosDate As Short, ByRef NewDosTime As Short, ByRef Newdir_CreateMSec As Byte, ByRef lpwNewdir_CreateTime As Short, ByRef Newdir_CreateDate As Short, ByRef lpwNewdir_LastAccessDate As Short) As Object

    ' ReadData : Direct read data in image.
    '  dwPos :  begin position
    '  dwSize : number of byte to copy (size of buffer)
    '  lpBuf :  buffer that will receive data
    'BOOL WIMAAPI ReadData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);
    Declare Function ReadData Lib "wimadll.dll" (ByVal Ima As Integer, ByVal dwPos As Integer, ByVal dwSize As Integer, ByVal lpBuf As String) As Boolean

    ' WriteData : Direct write data in image. Be carreful, WI don't refresh dir!
    '  dwPos :  begin position
    '  dwSize : number of byte to copy (size of buffer)
    '  lpBuf :  buffer that contain data
    'BOOL WIMAAPI WriteData(HIMA hIma,DWORD dwPos,DWORD dwSize,LPSTR lpBuf);
    Declare Function WriteData Lib "wimadll.dll" (ByVal Ima As Integer, ByVal dwPos As Integer, ByVal dwSize As Integer, ByVal lpBuf As String) As Boolean


    ' To be added : DRIVEINFO, GetFatImaSizeFileName, GetDriveInfo


    '//
    '// GetFatImaSizeFileName : Get information about UNCOMPRESSED Fat image
    '//   lpfn :          FileName
    '//   lpdwSize :      Will receive the size of the image, 32 bits low part of 64 bit data
    '//   lpdwSize!high : Will receive the size of the image, 32 bits high part of 64 bit data
    '//   lpfIsBigFat :   Boolean pointer, will receive TRUE if this is a large image (>2.88MB), not floppy image
    '//   lpdwPosInFile : Will receive the position of the image
    'BOOL WIMAAPI GetFatImaSizeFileName(LPCSTR lpFn,LPDWORD lpdwSize,LPDWORD lpdwSizeHigh,LPBOOL lpfIsBigFat,LPDWORD lpdwPosInFile);
    Declare Function GetFatImaSizeFileName Lib "wimadll.dll" (ByVal lpFn As String, ByRef lpdwSize As Integer, ByRef lpfIsBigFat As Boolean, ByRef lpdwPosInFile As Integer) As Boolean


    '// GetDriveInfo : Get info about drive type
    '//  bDrive : number of driver (0 = 'A:', 1 = 'B:')
    '//  return the kind of drive
    'DriveInfo return:
    '      NO_FLOPPY=0,
    '      FLOPPY_360=1,
    '      FLOPPY_12M=2,
    '      FLOPPY_720=3,
    '      FLOPPY_144=4,
    '      FLOPPY_288=5,
    '      LDISK_REMOVABLE=6,
    '      LDISK_HARDDISK=7,
    '      LDISK_CDROM=8,
    '      FLOPPY_LS120=9
    'DRIVEINFO WIMAAPI GetDriveInfo(BYTE bDrive);
    Declare Function GetDriveInfo Lib "wimadll.dll" (ByVal bDrive As Byte) As Integer


    '// Fill the ASPI Inquiry array.
    '// if lpAspiCdRomInquityTab is NULL AND dwMaxNumberInArray==0, just return the number of ASPI CDrom Unit.
    '//  lpAspiCdRomInquityTab : Will receive the Array of SCSI Unit
    '//  dwMaxNumberInArray : size of array (in number of ASPIINQUIRYTAB)
    'DWORD WIMAAPI WimLargeAspiCdromInquiryFillArray(ASPIINQUIRYTAB* lpAspiCdRomInquityTab,DWORD dwMaxNumberInArray);
    'UPGRADE_WARNING: Structure ASPIINQUIRYTAB may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.2003/commoner/redir/redirect.htm?keyword="vbup1050"'
    Declare Function WimLargeAspiCdromInquiryFillArray Lib "wimadll.dll" (ByRef AspiInqTab As ASPIINQUIRYTAB, ByVal dwMaxNumberInArray As Integer) As Integer

    '// Create a CDRom Image fro ASPI Unit, using dwHost and dwTargetID from AspiCdromInquiy
    '//   lpFn : Filename to create
    '//   lpdwTotal : will receive the filesize
    '// Note : I suggest using WimLargeReadAspiCDImageIgnoreError with fIgnoreError at FALSE
    'BOOL WIMAAPI WimLargeReadAspiCDImage(HWND hWnd,DWORD dwHost,DWORD dwTargetID,LPSTR lpFn,LPDWORD lpdwTotal);
    Declare Function WimLargeReadAspiCDImage Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal dwHost As Integer, ByVal dwTarget As Integer, ByVal lpFn As String, ByRef lpdwTotal As Integer) As Boolean


    '// Like WimLargeReadAspiCDImage
    '// fIgnoreError :
    '//    FALSE : if there is error ignore it only if the error is after ISO9660 size (suggested)
    '//    TRUE : Ignore all ISO 9660 error
    'BOOL WIMAAPI WimLargeReadAspiCDImageIgnoreError(HWND hWnd,DWORD dwHost,DWORD dwTargetID,LPSTR lpFn,LPDWORD lpdwTotal,BOOL fIgnoreError);
    Declare Function WimLargeReadAspiCDImageIgnoreError Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal dwHost As Integer, ByVal dwTarget As Integer, ByVal lpFn As String, ByRef lpdwTotal As Integer, ByVal fIgnoreError As Boolean) As Boolean

    Declare Function WimLargeReadAspiCDImageIgnoreErrorCB Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal dwHost As Integer, ByVal dwTarget As Integer, ByVal lpFn As String, ByRef lpdwTotal As Integer, ByVal fIgnoreError As Boolean) As Boolean




    '// return value != 0 if WimLargeReadLargeIma can be used with CDRom
    '// (elsewhere, only hard disk partition)
    'DWORD WIMAAPI WimLargeIsReadImaIsoPossible();
    Declare Function WimLargeIsReadImaIsoPossible Lib "wimadll.dll" () As Integer

    '// Read Disk partition to image
    '//  cDrive : disk letter ('C' for disk C:...)
    '//  lpdwTotal : will receive number of byte processed
    '//  caRead : USED, or ALL (ALL if you want read unused part of disk)
    'BOOL WIMAAPI WimLargeReadLargeIma(HWND hWnd,char cDrive,LPSTR lpFn,LPDWORD lpdwTotal,CHOICEAPP caRead);
    Declare Function WimLargeReadLargeIma Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal cDrive As Byte, ByVal lpFn As String, ByRef lpdwTotal As Integer, ByVal caRead As Integer) As Boolean

    Declare Function WimLargeReadLargeImaCB Lib "wimadll.dll" (ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal cDrive As Byte, ByVal lpFn As String, ByRef lpdwTotal As Integer, ByVal caRead As Integer) As Boolean
    '// Write Disk partition from image
    '//  cDrive : disk letter ('C' for disk C:...)
    '//  lpdwTotal : will receive number of byte processed
    '//  caWrite : USED or ALL
    '//  fCheckDiskBeforeWrite : if you want check disk is empty
    'BOOL WIMAAPI WimLargeWriteLargeIma(HIMA hIma,HWND hWnd,char cDrive,LPDWORD lpdwTotal,
    '                                   CHOICEAPP caWrite,BOOL fCheckDiskBeforeWriteThis);
    Declare Function WimLargeWriteLargeIma Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal cDrive As Byte, ByRef lpdwTotal As Integer, ByVal caWrite As Integer, ByVal fCheckDiskBeforeWriteThis As Boolean) As Boolean

    Declare Function WimLargeWriteLargeImaCB Lib "wimadll.dll" (ByVal Ima As Integer, ByVal hWnd As Integer, ByVal pEventNotifCallBack As WimCB, ByVal lpUsrParam As Integer, ByVal cDrive As Byte, ByRef lpdwTotal As Integer, ByVal caWrite As Integer, ByVal fCheckDiskBeforeWriteThis As Boolean) As Boolean


    '// say if a letter if a CDRom
    'BOOL WIMAAPI WimLargeIsIsoCDDrive(char cDrive);
    Declare Function WimLargeIsIsoCDDrive Lib "wimadll.dll" (ByVal cDrive As Byte) As Boolean

    '// Write the boot sector of an image
    'BOOL WIMAAPI WriteSectBoot(HIMA hIma,const BYTE* lpBuf,DWORD dwSizeBuf);
    Declare Function WriteSectBoot Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpBuf As String, ByVal dwSizeBuf As Integer) As Boolean

    '// Read the boot sector of an image
    'BOOL WIMAAPI GetSectBoot(HIMA hIma,LPBYTE lpBuf,DWORD dwSizeBuf,LPDWORD lpdwSizeBoot);
    Declare Function GetSectBoot Lib "wimadll.dll" (ByVal Ima As Integer, ByVal lpBuf As String, ByVal dwSizeBuf As Integer, ByRef lpdwSizeBoot As Integer) As Boolean



    ' // Get the total size of an image
    ' BOOL WIMAAPI GetImageSize(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh)
    Declare Function GetImageSize Lib "wimadll.dll" (ByVal Ima As Integer, ByRef lpdwLow As Integer, ByRef lpdwHigh As Integer) As Boolean

    ' // Get the free space in an image
    ' BOOL WIMAAPI GetFreeSpaceInImage(HIMA hIma,LPDWORD lpdwLow,LPDWORD lpdwHigh)
    Declare Function GetFreeSpaceInImage Lib "wimadll.dll" (ByVal Ima As Integer, ByRef lpdwLow As Integer, ByRef lpdwHigh As Integer) As Boolean
End Module
