/* sample written by Nathan Moinvaziri [nmoinvaziri@yahoo.com] */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <string.h>

#include <windows.h>

#include "wimadll.h"

class CUnIMG
{
public:

	CUnIMG() {};
	~CUnIMG() {};

	int ExtractIMG(LPSTR lpszImageFileName, LPSTR lpszDestDir);

private:

	char szPath[MAX_PATH];
	char szHemp[MAX_PATH];
	char szTemp[MAX_PATH];

	static DWORD WINAPI ExCB(DWORD, DWORD, DWORD, LPVOID, LPVOID);

	HIMA ProcessDIR(HIMA hIma, LPCSTR lpszCurrDir, LPCSTR lpszDestDir, UINT nFlags);
};

char szComp[MAX_PATH];

const int ISO_GETSIZE = 0;
const int ISO_EXTRACT = 1;

DWORD dwImaSize = 0;
DWORD dwImaSizeFinished = 0;
DWORD dwCurSize = 0;

DWORD WINAPI CUnIMG::ExCB(DWORD dwEvent, DWORD dwEventParam,DWORD dwWin32Err, LPVOID lpParam,LPVOID lpUsrParam)
{
	PROGRESSFILE_SUPINFO* hTmp = (PROGRESSFILE_SUPINFO*)lpParam;

	if(strcmp(szComp, hTmp->lpszName) != 0)
	{
		strcpy(szComp, hTmp->lpszName);

		dwImaSizeFinished += dwCurSize;
		dwCurSize = hTmp->dwTotalSize;

		//n++;
	}

	//printf("dwImaSize: %f", ;

	if(hTmp->dwTotalSize != 0)
		printf("   Iso - %2.02f%% %u/%u, %s - %2.02f%% %u/%u\n", (float)(dwImaSizeFinished + hTmp->dwCurrentPos)/dwImaSize*100, dwImaSizeFinished + hTmp->dwCurrentPos, dwImaSize, hTmp->lpszFullName, (float)hTmp->dwCurrentPos/hTmp->dwTotalSize*100, hTmp->dwCurrentPos, hTmp->dwTotalSize);

	return 0; // 2 to stop extraction
}


HIMA CUnIMG::ProcessDIR(HIMA hIma, LPCSTR lpszCurrDir, LPCSTR lpszDestDir, UINT nFlags)
{
    if (hIma == NULL)
	{
		printf("hIma was null\n");
		return hIma;
	}
	
	::CreateDirectory(lpszDestDir, NULL);

    DWORD dwNbFileRoot = GetNbEntryCurDir(hIma);

	DIRINFO* lpdi = (DIRINFO*)new char[sizeof(DIRINFO)*(dwNbFileRoot+1)];
	
    if (GetDirInfo(hIma, lpdi, SORT_NONE))
	{
		printf("Current Directory: %s %d Files\n", lpszCurrDir, dwNbFileRoot);

		// count file sizes
		if(nFlags == ISO_GETSIZE)
        for (DWORD i=0;i<dwNbFileRoot;i++)
			if(lpdi[i].szCompactName[0] != '.' && !lpdi[i].fIsSubDir)
				dwImaSize += lpdi[i].dwSize;

		// extract files and folders
		if(nFlags == ISO_EXTRACT)
        for (DWORD i=0;i<dwNbFileRoot;i++)
		{
			if(lpdi[i].szCompactName[0] != '.')
			{
				strcpy(szPath, lpszDestDir);
				strcat(szPath, lpszCurrDir);

				if(lpszCurrDir != "")
					strcat(szPath, "\\");

				strcpy(szTemp, szPath);

				if(lpdi[i].fLfnEntry)
					strcat(szPath, (lpdi+i)->longname);
				else
					strcat(szPath, (lpdi+i)->szCompactName);

				if((int)((lpdi+i)->bAttr) == 16)
					::CreateDirectory(szPath, NULL);
				else
				{
					if(ExtractFileCB(hIma, (EVENTNOTIFCALLBACK)ExCB, NULL, (lpdi+i)->uiPosInDir, szTemp, NULL))
						printf("Extracted %s\n", szPath);
					else
						printf("Unable to extract file %s\n", szPath);
				}
			}
		}

        for (DWORD i = 0; i < dwNbFileRoot; i++)
		{
			if(lpdi[i].szCompactName[0] != '.' && lpdi[i].fIsSubDir)
			{
                //char szHemp[MAX_PATH]; // GV : moved here (for recursion)

				if(!ChDirPos(hIma, CDM_ENTRY, lpdi[i].uiPosInDir)) 
					// Debug error here, doesn't goto printf. 
					// Doesn't return anything.
					printf("Unable to move to next directory.\n");

				strcpy(szHemp, lpszCurrDir);

                int iLnHemp = lstrlen(szHemp);
				
				if(lpszCurrDir != "")
					strcat(szHemp, "\\");

				if(lpdi[i].fLfnEntry)
					strcat(szHemp, lpdi[i].longname);
				else
					strcat(szHemp, lpdi[i].szCompactName);

				if(ProcessDIR(hIma, szHemp, lpszDestDir, nFlags) == NULL)
					printf("Err ProcessDIR returned NULL.\n");

                szHemp[iLnHemp]  = '\0';

				if(!ChDir(hIma, CDM_UPPER))
					printf("Unable to go back to prev. directory.\n");
			}
		}
	}

	delete lpdi;

	return hIma;
}

int CUnIMG::ExtractIMG(LPSTR lpszImageFileName, LPSTR lpszDestDir)
{	
    HIMA hIma = CreateCDIsoIma(lpszImageFileName);

    if (hIma != NULL)
        printf("ISO CdRom image %s opened\n",lpszImageFileName);
    else
    {
 		DWORD dwSizeIma,dwSizeImaHigh;       
        BOOL fOpenLargeFat=FALSE;
        DWORD dwPosInFile=0;

        if (GetFatImaSizeFileName(lpszImageFileName,&dwSizeIma,&dwSizeImaHigh,&fOpenLargeFat,&dwPosInFile))
        {
            hIma = OpenFatLargeFile(NULL,lpszImageFileName,0,0,TRUE);

            if (hIma != NULL)
                printf("Hard disk image %s opened\n\n",lpszImageFileName);
			else
				printf("Cannot open image %s\n\n",lpszImageFileName);
        }

        if ((hIma == NULL) && (!fOpenLargeFat))
        {
			BOOL fCompr = FALSE;

			hIma = CreateMemFatHima();

			if (hIma != NULL)
			{
				if (!ReadImaFile(hIma,/*NULL*/HWND_NO_PROGRESS, lpszImageFileName, &fCompr, 0))
				{
					DeleteIma(hIma);
					hIma= NULL;
				}
				else
					printf("Fat Floppy image %s opened\n\n",lpszImageFileName);
			}
        }
    }

	dwImaSize = 0;
	dwImaSizeFinished = 0;

	ProcessDIR(hIma, "", lpszDestDir, ISO_GETSIZE);
	
	if(hIma == NULL)
		printf("Error in ProcessDIR\n");
	
	ProcessDIR(hIma, "", lpszDestDir, ISO_EXTRACT);


	DeleteIma(hIma);

	return (hIma == NULL) ? 0 : 1;
}


int main(int argc,char *argv[])
{
	CUnIMG hImg;
    LPSTR lpszImageFileName;
    LPSTR lpszDestDir;

    if (argc>=3)
    {
        lpszImageFileName = argv[1];
        lpszDestDir = argv[2];
    }
    else
    {
        lpszImageFileName = "c:\\iso.iso" ;
        lpszDestDir = "c:\\temp\\";
    }

	if(!hImg.ExtractIMG(lpszImageFileName, lpszDestDir))
		printf("\nError occured while extracting.\n");
	else
		printf("\nAll files extracted successfully.\n");

	//while(1);
	return 0;
}
