

typedef struct
{
      unsigned char fill[1];
} VHDDISK_UINT1;

typedef struct
{
      unsigned char fill[2];
} VHDDISK_UINT2;

typedef struct
{
      unsigned char fill[4];
} VHDDISK_UINT4;

typedef struct
{
      unsigned char fill[8];
} VHDDISK_UINT8;

/* Hard disk footer fields */
typedef struct
{
    VHDDISK_UINT8 Cookie;
    VHDDISK_UINT4 Features;
    VHDDISK_UINT4 FileFormatVersion;
    VHDDISK_UINT8 DataOffset;
    VHDDISK_UINT4 TimeStamp;
    VHDDISK_UINT4 CreatorApplication;
    VHDDISK_UINT4 CreatorVersion;
    VHDDISK_UINT4 CreatorHostOS;
    VHDDISK_UINT8 OriginalSize;
    VHDDISK_UINT8 CurrentSize;
    VHDDISK_UINT4 DiskGeometry;
    VHDDISK_UINT4 DiskType;
    VHDDISK_UINT4 Checksum;
    unsigned char UniqueId[16];
    VHDDISK_UINT1 SavedState;
    unsigned char Reserved[427];
} HARDDISKFOOTER;

/* Dynamic Disk Header fields */

typedef struct
{
    VHDDISK_UINT4 PlatformCode;
    VHDDISK_UINT4 PlatformDataSpace;
    VHDDISK_UINT4 PlatformDataLength;
    VHDDISK_UINT4 Reserved;
    VHDDISK_UINT8 PlatformDataOffset;
} PARENTLOCATOR ;

typedef struct
{
    VHDDISK_UINT8 Cookie;
    VHDDISK_UINT8 DataOffset;
    VHDDISK_UINT8 TableOffset;
    VHDDISK_UINT4 HeaderVersion;
    VHDDISK_UINT4 MaxTableEntries;
    VHDDISK_UINT4 BlockSize;
    VHDDISK_UINT4 Checksum;
    unsigned char ParentUniqueId[16];
    VHDDISK_UINT4 ParentTimeStamp;
    VHDDISK_UINT4 Reserved;
    VHDDISK_UINT2 ParentUnicodeName[256];
    PARENTLOCATOR ParentLocatorEntry[8];
    unsigned char Reserved2[256];
} DYNAMICDISKHEADER;

typedef unsigned __int64 VHDMEMORY_UINT8;
typedef unsigned long VHDMEMORY_UINT4;
typedef unsigned short VHDMEMORY_UINT2;
typedef unsigned char VHDMEMORY_UINT1;

typedef int VHDMEMORY_BOOL;
#define VHDMEMORY_TRUE (1)
#define VHDMEMORY_FALSE (0)

#define DECLARE_VHDHANDLE(name)    struct name##__ { int _name##_unused; }; \
                                   typedef const struct name##__ * name


#define VHD_WIN32_ERROR_NOT_ENOUGH_MEMORY       (8)
#define VHD_WIN32_ERROR_BAD_LENGTH              (24)
#define VHD_WIN32_ERROR_INVALID_PARAMETER       (86)
