#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "crc.h"
#include "md5.h"
#include "md5ossl.h"
#include "sha.h"

#define CRCMETHOD_FL        (0)
#define CRCMETHOD_OLDZL     (1)
#define CRCMETHOD_NEWZL     (2)
#define CRCMETHOD_NEWZL120  (3)
#define CRCMETHOD_FL1       (4)
#define CRCMETHOD_ASM       (5)
#define CRCMETHOD_SP32      (6)
#define CRCMETHOD_SP64      (7)
#define CRCMETHOD_FL8       (8)
#define CRCMETHOD_ADLER     (9)
#define DEFAULT_CRC_METHOD  (3)

extern "C"
{
DWORD WINAPI crc32_newzl(DWORD crc,void* buf, DWORD len);
DWORD WINAPI crc32_newzl120(DWORD crc,void* buf, DWORD len);
DWORD WINAPI crc32_oldzl(DWORD crc,void* buf, DWORD len);
unsigned long SPcrc32(unsigned long crc,char* sequence, unsigned long len);
unsigned long SPcrc64(unsigned long crc,char* sequence, unsigned long len);
#ifdef CRC32ASM
DWORD crc32asm(DWORD crc,void* buf, DWORD len);
#endif
}

DWORD ManualBSwap(DWORD x)
{
    DWORD ret;
    ret =  ((((x) & 0xff)<<24) |
            (((x) & 0xff00)<<8) |
            (((x) & 0xff0000)>>8) |
            (((x) & 0xff000000)>>24));
    return ret;
}

void ManualBSwapPtr(DWORD * ptr1,DWORD *ptr2)
{
    DWORD x,y;
    x=*ptr1;
    y=*ptr1+1;
    
    *ptr2 =  ((((x) & 0xff)<<24) |
            (((x) & 0xff00)<<8) |
            (((x) & 0xff0000)>>8) |
            (((x) & 0xff000000)>>24));
    *(ptr2+1) =  ((((y) & 0xff)<<24) |
            (((y) & 0xff00)<<8) |
            (((y) & 0xff0000)>>8) |
            (((y) & 0xff000000)>>24));
    
}

void ManualBSwapPtr4(DWORD * ptr1,DWORD *ptr2)
{
    DWORD x,y,z,z2;
    x=*ptr1;
    y=*(ptr1+1);
    z=*(ptr1+2);
    z2=*(ptr1+3);
    
    *ptr2 =  ((((x) & 0xff)<<24) |
            (((x) & 0xff00)<<8) |
            (((x) & 0xff0000)>>8) |
            (((x) & 0xff000000)>>24));
    *(ptr2+1) =  ((((y) & 0xff)<<24) |
            (((y) & 0xff00)<<8) |
            (((y) & 0xff0000)>>8) |
            (((y) & 0xff000000)>>24));
    *(ptr2+2) =  ((((z) & 0xff)<<24) |
            (((z) & 0xff00)<<8) |
            (((z) & 0xff0000)>>8) |
            (((z) & 0xff000000)>>24));
    *(ptr2+3) =  ((((z2) & 0xff)<<24) |
            (((z2) & 0xff00)<<8) |
            (((z2) & 0xff0000)>>8) |
            (((z2) & 0xff000000)>>24));
}


DWORD ManualBSwap2(DWORD x)
{
    DWORD ret;
    WORD low,high;
    WORD newlow,newhigh;
    BYTE a,b,c,d;
    low = (WORD)x;
    high = (WORD)(x>>16);
    a = (BYTE)low;
    b = (BYTE)(low>>8);
    c = (BYTE)high;
    d = (BYTE)(high>>8);
    newhigh = (((WORD)a) << 8) | (b);
    newlow = (((WORD)c) << 8) | (d);
    ret =  (((DWORD)newhigh) << 16) | (newlow);
    return ret;
}

DWORD ComputeBufferCRCChoiceMethod(DWORD dwCRC, void *pvBuffer, DWORD cbBuffer,DWORD dwMethod)
{
    if (dwMethod==CRCMETHOD_FL)
      return ComputeBufferCRC(dwCRC,pvBuffer,cbBuffer);
    if (dwMethod== CRCMETHOD_OLDZL)
        return crc32_oldzl(dwCRC ^(0xffffffff),pvBuffer,cbBuffer)^(0xffffffff);
    if (dwMethod== CRCMETHOD_NEWZL)
        return crc32_newzl(dwCRC ^(0xffffffff),pvBuffer,cbBuffer)^(0xffffffff);
    if (dwMethod== CRCMETHOD_NEWZL120)
        return crc32_newzl120(dwCRC ^(0xffffffff),pvBuffer,cbBuffer)^(0xffffffff);
    if (dwMethod== CRCMETHOD_ADLER)
        return adler32(dwCRC,(LPBYTE)pvBuffer,cbBuffer);
    if (dwMethod==CRCMETHOD_FL1)
      return ComputeBufferCRC1(dwCRC,pvBuffer,cbBuffer);
    if (dwMethod==CRCMETHOD_FL8)
      return ComputeBufferCRC8(dwCRC,pvBuffer,cbBuffer);
    if (dwMethod==CRCMETHOD_SP32)
      return SPcrc32(dwCRC,(char*)pvBuffer,cbBuffer);
    if (dwMethod==CRCMETHOD_SP64)
      return SPcrc64(dwCRC,(char*)pvBuffer,cbBuffer);
#ifdef CRC32ASM
    if (dwMethod==CRCMETHOD_ASM)
      return crc32asm(dwCRC^(0xffffffff),pvBuffer,cbBuffer)^(0xffffffff);
#endif
    return dwMethod^(0xffffffff);
}

static void MyDoMinus64(LARGE_INTEGER &R,LARGE_INTEGER A,LARGE_INTEGER B)
{
    R.HighPart = A.HighPart - B.HighPart;
    if (A.LowPart >= B.LowPart)
        R.LowPart = A.LowPart - B.LowPart;
    else
    {
        R.LowPart = A.LowPart - B.LowPart;
        R.HighPart --;
    }
}

void BeginCountPerfCounter(LARGE_INTEGER * pbeginTime64,BOOL fComputeTimeQueryPerf)
{
    if ((!fComputeTimeQueryPerf) || (!QueryPerformanceCounter(pbeginTime64)))
    {
        pbeginTime64->LowPart = GetTickCount();
        pbeginTime64->HighPart = 0;
    }
}

DWORD GetMsecSincePerfCounter(LARGE_INTEGER beginTime64,BOOL fComputeTimeQueryPerf)
{
    LARGE_INTEGER endTime64,ticksPerSecond,ticks;
    DWORDLONG ticksShifted,tickSecShifted;
    DWORD dwLog=16+0;
    DWORD dwRet;
    if ((!fComputeTimeQueryPerf) || (!QueryPerformanceCounter(&endTime64)))
        dwRet = (GetTickCount() - beginTime64.LowPart)*1;
    else
    {
        MyDoMinus64(ticks,endTime64,beginTime64);
        QueryPerformanceFrequency(&ticksPerSecond);

    
        {
            ticksShifted = Int64ShrlMod32(*(DWORDLONG*)&ticks,dwLog);
            tickSecShifted = Int64ShrlMod32(*(DWORDLONG*)&ticksPerSecond,dwLog);
        
        } 

        dwRet = (DWORD)((((DWORD)ticksShifted)*1000)/(DWORD)(tickSecShifted));
        dwRet *=1;
    }
    return dwRet;
}


  #define DoTheCpuWork(pchFileBase,dwSizeFile) \
       { \
       int i; \
          for (i=0;i<iNbSuppCrc;i++) \
              ComputeBufferCRCChoiceMethod(0xFFFFFFFFL,pchFileBase,dwSizeFile,dwCrcMethod); \
          \
		  if (lpdwCrc!=NULL) \
           *lpdwCrc = ComputeBufferCRCChoiceMethod(*lpdwCrc,pchFileBase,dwSizeFile,dwCrcMethod); \
		  if (lpdwAdler!=NULL) \
		   *lpdwAdler=adler32(*lpdwAdler, (LPBYTE)pchFileBase,dwSizeFile); \
          if (lpMD5pms!=NULL) \
            md5_append(lpMD5pms,(LPBYTE)pchFileBase,dwSizeFile); \
		  if (lpMd5Ctx!=NULL) \
            MD5_Update(lpMd5Ctx,(LPBYTE)pchFileBase,dwSizeFile); \
          if (lpSha1Ctx!=NULL) \
            SHA1_Update(lpSha1Ctx,(LPBYTE)pchFileBase,dwSizeFile); \
          if (ptrcpy != NULL) \
           memcpy(ptrcpy,pchFileBase,dwSizeFile); \
       }

typedef struct
{
HANDLE hEventBeginIO;
HANDLE hEventEndIO;
// var written by main thread;
HANDLE hFile;
LPVOID lpBuffer;
DWORD nNumberOfBytesToRead;
BOOL  fContinue;
// var written by IO thread
DWORD dwNumberOfBytesRead;
BOOL  fResult;
DWORD dwLastError;
} THREADPARAM;

DWORD WINAPI ThreadFunc(LPVOID lpv)
{
THREADPARAM* pThreadParam=(THREADPARAM*)lpv;
    for (;;)
    {
        WaitForSingleObject(pThreadParam->hEventBeginIO,INFINITE);
        if (!(pThreadParam->fContinue))
            break;
        pThreadParam->fResult = ReadFile(pThreadParam->hFile,
                                         pThreadParam->lpBuffer,
                                         pThreadParam->nNumberOfBytesToRead,
                                         &(pThreadParam->dwNumberOfBytesRead),
                                         NULL);
        pThreadParam->dwLastError = GetLastError();
        SetEvent(pThreadParam->hEventEndIO);
    }
    return 0;
}

DWORD ReadAFile(char * pszBeginPath,char * fn,DWORD dwSizeFile,char * ptr,char * ptrcpy,
					DWORD dwSizeBlock,LPDWORD lpdwCrc,LPDWORD lpdwAdler,
					md5_state_t *lpMD5pms,
					MD5_CTX* lpMd5Ctx,
                    SHA_CTX* lpSha1Ctx,
                    DWORD dwCrcMethod,
                    BOOL fList,BOOL fMap,BOOL fNoBuffering,int iNbSuppCrc,
                    BOOL fOverlapped,BOOL fThread,BOOL fAskSequential,BOOL fComputeTimeQueryPerf)
{
LARGE_INTEGER beginTime64;
DWORD dwTime,dwCount;
DWORD dwRead;                 
HANDLE hf;
char szuseFn[MAX_PATH];
  if (fMap)
      fOverlapped=FALSE;

  lstrcpy(szuseFn,pszBeginPath);
  lstrcat(szuseFn,fn) ;
  dwCount = 0;
  BeginCountPerfCounter(&beginTime64,fComputeTimeQueryPerf);
  //hf = _lopen(fn,OF_READ) ;
  {
  //SECURITY_ATTRIBUTES sa;
  hf = CreateFile(szuseFn,GENERIC_READ,0,NULL,OPEN_EXISTING,
	  FILE_ATTRIBUTE_NORMAL | 
	  (fNoBuffering ? FILE_FLAG_NO_BUFFERING : 0) |
      (fOverlapped ? FILE_FLAG_OVERLAPPED : 0) |
      (fAskSequential ? FILE_FLAG_SEQUENTIAL_SCAN : 0),
      NULL);
  }

  if (lpdwCrc!=NULL)
    {
      //InitializeCRCTable();
      *lpdwCrc = 0xFFFFFFFFL;
    }
  if (lpdwAdler!=NULL)
      *lpdwAdler=adler32(0L, 0, 0);

  if (lpMD5pms!=NULL)
      md5_init(lpMD5pms);
  if (lpMd5Ctx!=NULL)
	  MD5_Init(lpMd5Ctx);
  if (lpSha1Ctx!=NULL)
      SHA1_Init(lpSha1Ctx);


  if (hf !=INVALID_HANDLE_VALUE)
    {
	  if (fMap)
	  {
      HANDLE hFileMap;
	  PCHAR  pchFileBase;

	      hFileMap = CreateFileMapping(hf, NULL, PAGE_READONLY, 0, 0, NULL);
		  pchFileBase = (PCHAR)MapViewOfFile(hFileMap, FILE_MAP_READ, 0, 0, 0);

          DoTheCpuWork(pchFileBase,dwSizeFile);

		  dwRead=dwSizeFile;
		  dwCount += dwRead;
          UnmapViewOfFile(pchFileBase);
          CloseHandle(hFileMap);
	  }
	  else if (fOverlapped)
      {
      OVERLAPPED ovr;
      char *ptra;
      char *ptrb;
      char *ptrn;
      DWORD dwTot=0;
      DWORD dwLast=0;
      BOOL  fParity=FALSE;

          memset(&ovr,0,sizeof(ovr));
          ptra=ptr;
          ptrb=ptr+dwSizeBlock;
          
          do
           {
           BOOL frf;
           DWORD dwrf;
		   DWORD dwDummy;
             ptrn = fParity ? ptrb : ptra;
		     
             ovr.Offset=dwTot;

             frf = ReadFile(hf,ptrn,dwSizeBlock,&dwDummy,&ovr);
             dwrf=GetLastError();

             DoTheCpuWork(ptr,dwLast);

             if ((!frf) && (dwrf!=ERROR_IO_PENDING))
                 break;
             
             GetOverlappedResult(hf,&ovr,&dwLast,TRUE);
             ptr=ptrn;
             fParity=!fParity;

             dwCount += dwLast;
             dwTot+=dwLast;
      
           } while (dwLast > 0);          
      }
      else if (fThread)
      {
      char *ptra;
      char *ptrb;
      char *ptrn;
      DWORD dwTot=0;
      DWORD dwLast=0;
      BOOL  fParity=FALSE;
      DWORD dwThreadId;
      THREADPARAM ThreadParam;
      HANDLE hTreadIO;

          ThreadParam.hEventBeginIO = CreateEvent(NULL,FALSE,FALSE, NULL);
          ThreadParam.hEventEndIO = CreateEvent(NULL,FALSE,FALSE, NULL);
          ThreadParam.hFile=hf;
          ThreadParam.fContinue=TRUE;
          ptra=ptr;
          ptrb=ptr+dwSizeBlock;
          hTreadIO=CreateThread(NULL,0,ThreadFunc,&ThreadParam,0,&dwThreadId);
          
          do
           {
           BOOL frf=FALSE;
           
             ptrn = fParity ? ptrb : ptra;

             ThreadParam.lpBuffer = ptrn;
             ThreadParam.nNumberOfBytesToRead = dwSizeBlock;

             SetEvent(ThreadParam.hEventBeginIO);
		     
             DoTheCpuWork(ptr,dwLast);

             
             WaitForSingleObject(ThreadParam.hEventEndIO,INFINITE);
             dwLast = (ThreadParam.fResult) ? (ThreadParam.dwNumberOfBytesRead) : 0;
             ptr=ptrn;
             fParity=!fParity;

             dwCount += dwLast;
             dwTot+=dwLast;
      
           } while (dwLast > 0);          

          ThreadParam.fContinue=FALSE;
          SetEvent(ThreadParam.hEventBeginIO);

          WaitForSingleObject(hTreadIO,INFINITE);

          CloseHandle(ThreadParam.hEventBeginIO);
          CloseHandle(ThreadParam.hEventEndIO);
      }
      else
      {
          do
           {         
		     dwRead=0;
             ReadFile(hf,ptr,dwSizeBlock,&dwRead,NULL);

             DoTheCpuWork(ptr,dwRead);

             dwCount += dwRead;
      
           } while (dwRead > 0);
      }
      CloseHandle(hf);
    }

  dwTime = GetMsecSincePerfCounter(beginTime64,fComputeTimeQueryPerf);
  if (!fList)
	   printf("File=%6u Kb/Sec with %9u bytes : %s",dwCount/(1+dwTime),dwCount,fn);
  else
	  printf("%s,%s,%s,%u",pszBeginPath,szuseFn,fn,dwCount);
  if (lpdwCrc!=NULL)
    {
      *lpdwCrc = ((*lpdwCrc) ^= 0xFFFFFFFFL);
	  if (fList) printf(","); else printf(" ");
      printf("Crc=%lX",*lpdwCrc);
    }
  if (lpdwAdler!=NULL)
    {
      if (fList) printf(","); else printf(" ");
      printf("Adler=%lX",*lpdwAdler);
    }

  if (lpMd5Ctx!=NULL)
  {
      int i;
      unsigned char digest[16];
      MD5_Final(digest,lpMd5Ctx);
      if (fList) printf(","); else printf(" ");
      printf("Md5=");
      for (i=0;i<16;i++)
          printf("%02x",digest[i]);      
  }

  if (lpMD5pms!=NULL)
  {
      int i;
      md5_byte_t digest[16];
      md5_finish(lpMD5pms, digest);
      if (fList) printf(","); else printf(" ");
      printf("Md5lib=");
      for (i=0;i<16;i++)
          printf("%02x",digest[i]);      
  }

  if (lpSha1Ctx!=NULL)
  {
      int i;
      unsigned char digest[20];
      SHA1_Final(digest,lpSha1Ctx);
      if (fList) printf(","); else printf(" ");
      printf("Sha1=");
      for (i=0;i<20;i++)
          printf("%02x",digest[i]);      
  }

  printf("\n");
  return dwCount;
}

void testmem(BOOL fComputeTimeQueryPerf)
{
DWORD dwSize = 0x10000 * 0x10*2;
char * base;
char * ptr1;
char * ptr2;
int i;
DWORD dwTimeAll;
LARGE_INTEGER beginTime64All;
DWORD dwCount;
  base = (char*)malloc(dwSize*2);
  ptr1 = base;
  ptr2 = base + dwSize;
  memset(ptr1,0,dwSize);
  dwCount=0;



  BeginCountPerfCounter(&beginTime64All,fComputeTimeQueryPerf);
  for (i=0;i<5;i++)
	 {
         LARGE_INTEGER beginTime64Local;
         DWORD dwTimePrecis;
		 
         BeginCountPerfCounter(&beginTime64Local,fComputeTimeQueryPerf);
		 memcpy(ptr2,ptr1,dwSize);
		 
         dwTimePrecis = GetMsecSincePerfCounter(beginTime64Local,fComputeTimeQueryPerf);
		 printf(": %6u Kb/Sec with %9u bytes on mem\n",dwSize/(1+dwTimePrecis),dwSize);
		 dwCount += dwSize;
	 }
  dwTimeAll = GetMsecSincePerfCounter(beginTime64All,fComputeTimeQueryPerf);
  printf("= %6u Kb/Sec with %9u bytes on mem\n",dwCount/(1+dwTimeAll),dwCount);
  free(base);
}

void txthelp()
{
printf("Usage: READFILE                     test memcopy speed\n" \
       "       READFILE filespec            test file reading (bypass cache)\n" \
       "       READFILE filespec /d         test file reading + copy mem\n" \
       "       READFILE filespec /c         test file reading + compute CRC32\n" \
       "       READFILE filespec /s         test file reading + rec. dir parse\n" \
       "       READFILE filespec /l         test file reading + listing output\n" \
       "       READFILE filespec /b         enable the file system buffering\n" \
       "       READFILE filespec /m         use file mapped IO (incompat. with /t & /o)\n" \
       "       READFILE filespec /a         calculate Adler code\n" \
       "       READFILE filespec /g         calculate MD5 code\n" \
       "       READFILE filespec /t         using small buffer (64 KB instead 1 MB)\n" \
       "       READFILE filespec /r         slow CRC-32 computation\n" \
       "       READFILE filespec /o         using overlapped I/O\n" \
       "       READFILE filespec /h         using multi-thread\n" \
       " filespec is file specification with joker, by example : *.*\n" \
	   );
}

LPSTR GetOnlyJoker(LPSTR lpFn)
{
LPSTR lpRet=lpFn;
  while ((*lpFn) != '\0')
  {
	  if ((*lpFn)==':') lpRet = lpFn+1;
	  if ((*lpFn)=='\\') lpRet = lpFn+1;
	  lpFn++;
  }
  return lpRet;
}

DWORD DoLoopFile(LPSTR szBeginPath,LPSTR lpFN,LPSTR ptr,LPSTR ptrcpy,
				 DWORD dwSizeBlock,LPDWORD lpdwCrc,LPDWORD lpdwAdler,
                 md5_state_t *lpMD5pms,
				 MD5_CTX* lpMd5Ctx,
                 SHA_CTX* lpSha1Ctx,
                 DWORD dwCrcMethod,
				 BOOL fList,
				 BOOL fRecursive,BOOL fMap,
                 BOOL fNoBuffering,int iNbSuppCrc,BOOL fOverlapped,
                 BOOL fThread,BOOL fAskSequential,BOOL fComputeTimeQueryPerf)
{
WIN32_FIND_DATA ffblk;
HANDLE hFind;
DWORD dwCount=0;
  if ((hFind = FindFirstFile(lpFN,&ffblk)) == INVALID_HANDLE_VALUE)
	 return 0;
  
		do
		{
		  if (!(ffblk.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			 dwCount += ReadAFile(szBeginPath,ffblk.cFileName,ffblk.nFileSizeLow,
										ptr,ptrcpy,
										dwSizeBlock,lpdwCrc,lpdwAdler,
										lpMD5pms,lpMd5Ctx,
                                        lpSha1Ctx,
                                        dwCrcMethod,fList,fMap,
                                        fNoBuffering,iNbSuppCrc,
                                        fOverlapped,fThread,fAskSequential,fComputeTimeQueryPerf);
		  else if (fRecursive && (strcmp(ffblk.cFileName,".")!=0) && 
			                     (strcmp(ffblk.cFileName,"..")!=0))
		  {
		  char szNewPath[MAX_PATH];
		  char szNewFN[MAX_PATH];
		    wsprintf(szNewPath,"%s%s\\",(LPSTR)szBeginPath,(LPSTR)ffblk.cFileName);
			wsprintf(szNewFN,"%s%s",(LPSTR)szNewPath,GetOnlyJoker(lpFN));
			dwCount += DoLoopFile(szNewPath,szNewFN,ptr,ptrcpy,dwSizeBlock,lpdwCrc,lpdwAdler,
				                                    lpMD5pms,lpMd5Ctx,lpSha1Ctx,
                                                    dwCrcMethod,fList,
													fRecursive,fMap,fNoBuffering,iNbSuppCrc,
                                                    fOverlapped,fThread,fAskSequential,fComputeTimeQueryPerf); 
		  }

		} while (FindNextFile(hFind,&ffblk));
  FindClose(hFind);
  return dwCount;
}

void main(int argc,char *argv[])
{
DWORD dwTime,dwCount;
LARGE_INTEGER beginTime64;
char * ptr;
char * ptrcpy=NULL;
DWORD dwSizeBlock ;
BOOL fDouble=FALSE;
BOOL fCrc=FALSE;
BOOL fList=FALSE;
BOOL fRecursive=FALSE;
BOOL fMap=FALSE;
BOOL fNoBuffering=TRUE;
BOOL fAdler=FALSE;
BOOL fMd5=FALSE;
BOOL fMd5SSL=FALSE;
BOOL fSha1=FALSE;
BOOL fSmallBuf=FALSE;
BOOL fThread=FALSE;
BOOL fAskSequential=FALSE;
int iNbSuppCrc=0;
BOOL fOverlapped=FALSE;
LPDWORD lpdwCrc=NULL;
LPDWORD lpdwAdler=NULL;
md5_state_t md5_pms;
MD5_CTX md5_ctx;
SHA_CTX sha1_ctx;
DWORD dwCrcMethod=DEFAULT_CRC_METHOD;
DWORD dwCrc,dwAdler;
int i;
char szBeginPath[ MAX_PATH ];
BOOL fComputeTimeQueryPerf = TRUE;

  InitializeCRCTable();
  printf("ReadFile 1.60 - http://www.winimage.com/readfile.htm\n");

  if (argc == 1)
	 {
        txthelp();
		testmem(fComputeTimeQueryPerf);
        {
            DWORD array1[0x10];
            DWORD array2[0x10];
        ManualBSwap(GetTickCount());
        ManualBSwap2(GetTickCount());
        ManualBSwapPtr(array1,array2);
        ManualBSwapPtr4(array1,array2);
        }
		return;
	 }
  dwSizeBlock = 65536L * 16;
  ptr = (char*)malloc(dwSizeBlock*2) ;
  if (ptr==NULL)
	 return;
  i=2;
  while (argv[i]!=NULL)
    {
	char c=*(argv[i]);
	char c2=0;
    int iadv=0;
	if ((c=='-') || (c=='/'))
	{
		iadv=1;
	    c=*(argv[i]+(iadv));
	}
	if (c!=0)
	  c2=*(argv[i]+(iadv)+1);
	if ((c>='a') && (c<='z')) c-=0x20;
	if ((c2>='a') && (c2<='z')) c2-=0x20;

	 if (((c)) == 'D')
           fDouble=TRUE;
	 if (((c)) == 'S')
     {
         if (c2=='H')
             fSha1=TRUE;
         else
             fRecursive=TRUE;
     }
	 if (((c)) == 'Q')
           fAskSequential = TRUE;
	 if (((c)) == 'C')
           fCrc=TRUE;
	 if (((c)) == 'L')
           fList=TRUE;
	 if (((c)) == 'B')
	       fNoBuffering=FALSE; 
     if (((c)) == 'I')
           fComputeTimeQueryPerf=FALSE;
	 if (((c)) == 'M')
           fMap=TRUE;
	 if (((c)) == 'A')
           fAdler=TRUE;
	 if (((c)) == 'G')
	 {
              /*
		 if (c2=='O')
			 fMd5SSL=TRUE;
		 else
			 fMd5=TRUE;
              */
		 if (c2=='D')
			 fMd5=TRUE;
		 else
			 fMd5SSL=TRUE;
	 }
           
	 if (((c)) == 'T')
           fSmallBuf=TRUE;
	 if (((c)) == 'H')
           fThread=TRUE;
     if (((c)) == 'R')
     {
     char cn=*(argv[i]+iadv+1);
       if ((cn>='0') && (cn<='9'))
       {
           char cn2=*(argv[i]+iadv+2);
           if ((cn2>='0') && (cn2<='9'))
             iNbSuppCrc=((cn2-'0')+((cn-'0')*10));
           else
             iNbSuppCrc=cn-'0';
           if (iNbSuppCrc>0)
               iNbSuppCrc--;           
       }
       else
           iNbSuppCrc=2;
           fCrc=TRUE;
     }
     if (((c)) == 'E')
     {
     char cn=*(argv[i]+iadv+1);
       if ((cn>='1') && (cn<='9'))
           dwCrcMethod=cn-'0';
     }
     if (((c)) == 'O')
           fOverlapped=TRUE;
     if (((c)) == 'P')
           dwSizeBlock=65536*4;
         i++;
    }

    if (fSmallBuf)
        dwSizeBlock=min(dwSizeBlock,65536L);
             
    if (fCrc)
      lpdwCrc = &dwCrc;

    if (fAdler)
      lpdwAdler = &dwAdler;


    if (fDouble)
		ptrcpy = (char*)malloc(dwSizeBlock) ;

  if (ptrcpy!=NULL)
	 printf("Use double-buffering\n");

  BeginCountPerfCounter(&beginTime64,fComputeTimeQueryPerf);

  szBeginPath[0]='\0';
  for (i=0;i<lstrlen(argv[1]);i++)
  {
  char c=*(argv[1]+i);
    if ((c=='\\') || (c==':'))
    {
	  memcpy(szBeginPath,argv[1],i+1);
      szBeginPath[i+1]='\0';
	}
  }
  dwCount = DoLoopFile(szBeginPath,argv[1],ptr,ptrcpy,dwSizeBlock,lpdwCrc,lpdwAdler,
                       fMd5 ? &md5_pms:NULL,
					   fMd5SSL ? &md5_ctx:NULL,
                       fSha1 ? &sha1_ctx:NULL,
                       dwCrcMethod,
	                   fList,fRecursive,fMap,fNoBuffering,iNbSuppCrc,
                       fOverlapped,fThread,fAskSequential,fComputeTimeQueryPerf);

  dwTime = GetMsecSincePerfCounter(beginTime64,fComputeTimeQueryPerf);
  printf("Average = %6u Kb/Sec with %9u bytes (total : %u msec)\n",
                        dwCount/(1+dwTime),dwCount,dwTime);
  free(ptr);
  if (ptrcpy != NULL)
    free(ptrcpy);
}
