
#ifndef gvmd5_INCLUDED
#  define gvmd5_INCLUDED

#ifdef __cplusplus
extern "C" 
{
#endif

#if (!defined(MD5_ONLY_OPENSSL)) && (!defined(NO_MD5_ONLY_OPENSSL)) 
#define MD5_ONLY_OPENSSL
#endif

#if ((!(defined(WIMA_SFX))) && (!(defined(md5_openssl))) && (defined(PFRFEATURE))) || defined(MD5_ONLY_OPENSSL)
#define md5_openssl
#endif


#ifdef md5_openssl
#include "md5ossl.h"
typedef struct
{
    MD5_CTX ctx;
} GVMD5_INTERNAL;

static void gvmd5_init(GVMD5_INTERNAL* pgv_mds)
 { MD5_Init(&pgv_mds->ctx) ; }

static void gvmd5_append(GVMD5_INTERNAL*pgv_mds, const unsigned char* buf, int nbytes)
 { MD5_Update(&pgv_mds->ctx,(const void *)buf,(unsigned long)nbytes); }

static void gvmd5_finish(GVMD5_INTERNAL*pgv_mds, unsigned char digest[16])
 { MD5_Final((unsigned char*)digest,&pgv_mds->ctx); }

#else
#include "md5.h"
typedef struct
{
  md5_state_t mds;
} GVMD5_INTERNAL;

static void gvmd5_init(GVMD5_INTERNAL* pgv_mds)
  { md5_init(&pgv_mds->mds) ; }

static void gvmd5_append(GVMD5_INTERNAL*pgv_mds, const unsigned char* buf, int nbytes)
  { md5_append(&pgv_mds->mds,buf,nbytes) ; }

static void gvmd5_finish(GVMD5_INTERNAL*pgv_mds, unsigned char digest[16])
  { md5_finish(&pgv_mds->mds,digest) ; }


#endif

/*
void gvmd5_init(GVMD5_INTERNAL*);

void gvmd5_append(GVMD5_INTERNAL*, const unsigned char*, int nbytes);

void gvmd5_finish(GVMD5_INTERNAL*, unsigned char digest[16]);
*/

#ifdef __cplusplus
}  /* end extern "C" */
#endif

#endif