#include <stdlib.h>
#include <stdio.h>

#define AUTODIN_IIREV	0xEDB88320
#define POLY64REV	((unsigned __int64)0xd800000000000000UL)

unsigned long SPcrc32(unsigned long crc,char* sequence, unsigned long len)
{
  static unsigned long CRCTable[256];
  static int init = 0;
  /*unsigned long crc = 0xFFFFFFFF;  */

  if (!init) {
    int i;
    init = 1;
    for (i = 0; i <= 255; i++) {
      int j;
      unsigned part = i;
      for (j = 0; j < 8; j++) {
        if (part & 1)
          part = (part >> 1) ^ AUTODIN_IIREV;
        else
          part >>= 1;
      }
      CRCTable[i] = part;
    }
  }
  while (len>0) {
    unsigned temp1 = crc >> 8;
    unsigned temp2 = CRCTable[(crc ^ (unsigned) *sequence) & 0xff];
    crc = temp1 ^ temp2;
    sequence += 1;
    len--;
  } 
  /*sprintf(res, "%08X", crc);*/
  return crc;
}

unsigned long SPcrc64(unsigned long crcparam,char* sequence, unsigned long len)
//void SPcrc64(char* sequence, char* res)
{
  static unsigned _int64 CRCTable[256];
  unsigned _int64  crc = crcparam ^((unsigned _int64)(0xffffffffffffffff));
  static int init = 0;
  unsigned long low = 0;
  unsigned long high = 0;
crc=0;
  if (!init) {
    int i;
    init = 1;
    for (i = 0; i <= 255; i++) {
      int j;
      unsigned _int64 part = i;
      for (j = 0; j < 8; j++) {
        if (part & 1)
          part = (part >> 1) ^ POLY64REV;
        else
          part >>= 1;
      }
      CRCTable[i] = part;
    }
  }

  {
  low = (unsigned long)(crc & 0xffffffff);
  high = (unsigned long)((crc >> 32) & 0xffffffff);
  printf( "init: crc64=%08X%08X len=%u\n", 
	  high,  low,len );
  }

  while (len>0) {
    unsigned _int64 temp1
      = crc >> 8;
    unsigned _int64 temp2
      = CRCTable[(crc ^ (unsigned _int64) *sequence) & 0xff];
    crc = temp1 ^ temp2;
    sequence += 1;
    len--;
  }
  /* 
     The output is done in two parts to avoid problems with 
     architecture-dependent word order
     */
  {
  low = (unsigned long)(crc & 0xffffffff);
  high = (unsigned long)((crc >> 32) & 0xffffffff);
  printf( "crc64=%08X%08X\n", 
	  high, 
	  low
	  );
  }
  return low;
}

